/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.reflection;

import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.function.Supplier;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import spring.turbo.util.ClassUtils;
import spring.turbo.util.reflection.InstantiationExceptionSupplier;

public final class InstanceUtils {
    private InstanceUtils() {
    }

    public static <T> T newInstanceElseThrow(Class<T> clazz) {
        return InstanceUtils.newInstanceElseThrow(clazz, new InstantiationExceptionSupplier(clazz));
    }

    public static <T> T newInstanceElseThrow(Class<T> clazz, Supplier<? extends RuntimeException> supplier) {
        return InstanceUtils.newInstance(clazz).orElseThrow(supplier);
    }

    public static <T> Optional<T> newInstance(Class<T> clazz) {
        try {
            Constructor constructor = ReflectionUtils.accessibleConstructor(clazz, (Class[])new Class[0]);
            ReflectionUtils.makeAccessible((Constructor)constructor);
            return Optional.of(constructor.newInstance(new Object[0]));
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    public static <T> Optional<T> newInstance(String string) {
        try {
            Class<?> clazz = ClassUtils.forNameElseThrow(string);
            return InstanceUtils.newInstance(clazz);
        }
        catch (Throwable throwable) {
            return Optional.empty();
        }
    }

    @Nullable
    public static <T> T newInstanceElse(Class<T> clazz, @Nullable T t) {
        return InstanceUtils.newInstance(clazz).orElse(t);
    }

    @Nullable
    public static <T> T newInstanceElse(String string, @Nullable T t) {
        return InstanceUtils.newInstance(string).orElse(t);
    }

    @Nullable
    public static <T> T newInstanceElseGet(Class<T> clazz, Supplier<? extends T> supplier) {
        return InstanceUtils.newInstance(clazz).orElseGet(supplier);
    }

    @Nullable
    public static <T> T newInstanceElseGet(String string, Supplier<? extends T> supplier) {
        return InstanceUtils.newInstance(string).orElseGet(supplier);
    }
}

