/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;
import org.springframework.util.Assert;

public final class MethodPredicateFactories {
    private MethodPredicateFactories() {
    }

    public static Predicate<Method> alwaysTrue() {
        return method -> true;
    }

    public static Predicate<Method> alwaysFalse() {
        return method -> false;
    }

    public static Predicate<Method> not(Predicate<Method> predicate) {
        Assert.notNull(predicate, (String)"predicate is required");
        return method -> !predicate.test((Method)method);
    }

    @SafeVarargs
    public static Predicate<Method> any(Predicate<Method> ... predicateArray) {
        Assert.notNull(predicateArray, (String)"predicate is required");
        Assert.isTrue((predicateArray.length >= 1 ? 1 : 0) != 0, (String)"predicate must greater than 1");
        return method -> {
            for (Predicate predicate : predicateArray) {
                if (!predicate.test(method)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    public static Predicate<Method> all(Predicate<Method> ... predicateArray) {
        Assert.notNull(predicateArray, (String)"predicate is required");
        Assert.isTrue((predicateArray.length >= 1 ? 1 : 0) != 0, (String)"predicate must greater than 1");
        return method -> {
            for (Predicate predicate : predicateArray) {
                if (predicate.test(method)) continue;
                return false;
            }
            return true;
        };
    }

    public static Predicate<Method> isUserDeclaredMethod() {
        return method -> !method.isBridge() && !method.isSynthetic() && method.getDeclaringClass() != Object.class;
    }

    public static Predicate<Method> isNotUserDeclaredMethod() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isUserDeclaredMethod());
    }

    public static Predicate<Method> withAnnotation(Class<? extends Annotation> clazz) {
        return method -> method.getAnnotation(clazz) != null;
    }

    public static Predicate<Method> withoutAnnotation(Class<? extends Annotation> clazz) {
        return MethodPredicateFactories.not(MethodPredicateFactories.withAnnotation(clazz));
    }

    public static Predicate<Method> isPublic() {
        return method -> Modifier.isPublic(method.getModifiers());
    }

    public static Predicate<Method> isNotPublic() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isPublic());
    }

    public static Predicate<Method> isPrivate() {
        return method -> Modifier.isPrivate(method.getModifiers());
    }

    public static Predicate<Method> isNotPrivate() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isPrivate());
    }

    public static Predicate<Method> isProtected() {
        return method -> Modifier.isProtected(method.getModifiers());
    }

    public static Predicate<Method> isNotProtected() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isProtected());
    }

    public static Predicate<Method> isStatic() {
        return method -> Modifier.isStatic(method.getModifiers());
    }

    public static Predicate<Method> isNotStatic() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isStatic());
    }

    public static Predicate<Method> isFinal() {
        return method -> Modifier.isFinal(method.getModifiers());
    }

    public static Predicate<Method> isNotFinal() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isFinal());
    }

    public static Predicate<Method> isAbstract() {
        return method -> Modifier.isAbstract(method.getModifiers());
    }

    public static Predicate<Method> isNotAbstract() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isAbstract());
    }

    public static Predicate<Method> isNative() {
        return method -> Modifier.isNative(method.getModifiers());
    }

    public static Predicate<Method> isNotNative() {
        return MethodPredicateFactories.not(MethodPredicateFactories.isNative());
    }
}

