/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.reflection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.util.ReflectionUtils;

public final class MethodUtils {
    private MethodUtils() {
    }

    public static void makeAccessible(Method method) {
        ReflectionUtils.makeAccessible((Method)method);
    }

    public static List<Method> find(Class<?> clazz) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        ReflectionUtils.doWithMethods(clazz, arrayList::add);
        return arrayList;
    }

    public static List<Method> find(Class<?> clazz, String string) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Optional.ofNullable(ReflectionUtils.findMethod(clazz, (String)string)).ifPresent(arrayList::add);
        return arrayList;
    }

    public static List<Method> find(Class<?> clazz, String string, Class<?> ... classArray) {
        ArrayList<Method> arrayList = new ArrayList<Method>();
        Optional.ofNullable(ReflectionUtils.findMethod(clazz, (String)string, (Class[])classArray)).ifPresent(arrayList::add);
        return arrayList;
    }
}

