/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.spi;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.OrderComparator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.ClassUtils;

public final class ServiceLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ServiceLoaderUtils.class);

    private ServiceLoaderUtils() {
    }

    public static <T> List<T> load(Class<T> clazz) {
        return ServiceLoaderUtils.load(clazz, null);
    }

    public static <T> List<T> load(Class<T> clazz, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, (String)"targetType is required");
        try {
            classLoader = Objects.requireNonNullElseGet(classLoader, ClassUtils::getDefaultClassLoader);
            ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, classLoader);
            LinkedList<T> linkedList = new LinkedList<T>();
            for (T t : serviceLoader) {
                linkedList.add(t);
            }
            OrderComparator.sort(linkedList);
            return Collections.unmodifiableList(linkedList);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            log.warn(serviceConfigurationError.getMessage(), (Throwable)serviceConfigurationError);
            throw serviceConfigurationError;
        }
    }

    public static <T> List<T> loadQuietly(Class<T> clazz) {
        return ServiceLoaderUtils.loadQuietly(clazz, null);
    }

    public static <T> List<T> loadQuietly(Class<T> clazz, @Nullable ClassLoader classLoader) {
        try {
            return ServiceLoaderUtils.load(clazz, classLoader);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            return Collections.emptyList();
        }
    }
}

