/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.core.OrderComparator;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import spring.turbo.util.StringDefaults;
import spring.turbo.util.collection.CollectionUtils;

public final class SpringFactoriesUtils {
    private static final SpringFactoriesLoader.FailureHandler NOOP = (clazz, string, throwable) -> {};

    private SpringFactoriesUtils() {
    }

    public static <T> List<T> loadQuietly(Class<T> clazz) {
        return SpringFactoriesUtils.loadQuietly(clazz, null);
    }

    public static <T> List<T> loadQuietly(Class<T> clazz, @Nullable String string) {
        return SpringFactoriesUtils.loadQuietly(clazz, string, null);
    }

    public static <T> List<T> loadQuietly(Class<T> clazz, @Nullable String string, @Nullable ClassLoader classLoader) {
        Assert.notNull(clazz, (String)"factoryType is required");
        string = StringDefaults.blankToDefault(string, "META-INF/spring.factories");
        classLoader = Objects.requireNonNullElse(classLoader, ClassUtils.getDefaultClassLoader());
        SpringFactoriesLoader springFactoriesLoader = SpringFactoriesLoader.forResourceLocation((String)string, (ClassLoader)classLoader);
        try {
            ArrayList arrayList = new ArrayList();
            List list = springFactoriesLoader.load(clazz, NOOP);
            CollectionUtils.nullSafeAddAll(arrayList, list);
            OrderComparator.sort(arrayList);
            return Collections.unmodifiableList(arrayList);
        }
        catch (Throwable throwable) {
            return List.of();
        }
    }
}

