/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.text;

import java.util.Arrays;
import org.springframework.lang.Nullable;
import spring.turbo.util.CharSequenceUtils;

public interface StringMatcher {
    public static StringMatcher andMatcher(StringMatcher ... stringMatcherArray) {
        if (stringMatcherArray == null || stringMatcherArray.length == 0) {
            return new None();
        }
        if (stringMatcherArray.length == 1) {
            return stringMatcherArray[0];
        }
        return new And(stringMatcherArray);
    }

    public static StringMatcher noneMatcher() {
        return new None();
    }

    public static StringMatcher charMatcher(char c) {
        return new Char(c);
    }

    public static StringMatcher charSetMatcher(char ... cArray) {
        int n;
        int n2 = n = cArray != null ? cArray.length : 0;
        if (n == 0) {
            return new None();
        }
        if (n == 1) {
            return new Char(cArray[0]);
        }
        return new CharSet(cArray);
    }

    public static StringMatcher charSetMatcher(@Nullable String string) {
        if (string == null) {
            return new None();
        }
        int n = string.length();
        if (n == 0) {
            return new None();
        }
        if (n == 1) {
            return new Char(string.charAt(0));
        }
        return new CharSet(string.toCharArray());
    }

    public static StringMatcher commaMatcher() {
        return new Char(',');
    }

    public static StringMatcher singleQuoteMatcher() {
        return new Char('\'');
    }

    public static StringMatcher doubleQuoteMatcher() {
        return new Char('\"');
    }

    public static StringMatcher quoteMatcher() {
        return new CharSet(new char[]{'\'', '\"'});
    }

    public static StringMatcher spaceMatcher() {
        return new Char(' ');
    }

    public static StringMatcher tabMatcher() {
        return new Char('\t');
    }

    public static StringMatcher hyphenMatcher() {
        return new Char('-');
    }

    public static StringMatcher colonMatcher() {
        return new Char(':');
    }

    public static StringMatcher doubleColonMatcher() {
        return new CharArray("::".toCharArray());
    }

    public static StringMatcher underscoreMatcher() {
        return new Char('_');
    }

    public static StringMatcher atMarkerMatcher() {
        return new Char('@');
    }

    public static StringMatcher dotMatcher() {
        return new Char('.');
    }

    public static StringMatcher semicolonMatcher() {
        return new Char(';');
    }

    public static StringMatcher slashMatcher() {
        return new Char('/');
    }

    public static StringMatcher backslashMatcher() {
        return new Char('\\');
    }

    public static StringMatcher slashAndBackslashMatcher() {
        return new CharSet(new char[]{'/', '\\'});
    }

    public static StringMatcher whitespaceMatcher() {
        return new Whitespace();
    }

    public static StringMatcher numericMatcher() {
        return new CharSet(new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'});
    }

    public static StringMatcher lowerMatcher() {
        return new CharSet(new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'});
    }

    public static StringMatcher upperMatcher() {
        return new CharSet(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'});
    }

    public static StringMatcher alphaMatcher() {
        return new CharSet(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'});
    }

    public static StringMatcher alphanumericMatcher() {
        return new CharSet(new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'});
    }

    public static StringMatcher splitMatcher() {
        return new CharSet(" \t\n\r\f".toCharArray());
    }

    public static StringMatcher stringMatcher(char ... cArray) {
        int n;
        int n2 = n = cArray != null ? cArray.length : 0;
        return n == 0 ? new None() : (n == 1 ? new Char(cArray[0]) : new CharArray(cArray));
    }

    public static StringMatcher stringMatcher(@Nullable String string) {
        if (string == null) {
            return new None();
        }
        return string.isEmpty() ? new None() : StringMatcher.stringMatcher(string.toCharArray());
    }

    default public int isMatch(char[] cArray, int n) {
        return this.isMatch(cArray, n, 0, cArray.length);
    }

    public int isMatch(char[] var1, int var2, int var3, int var4);

    default public int isMatch(CharSequence charSequence, int n) {
        return this.isMatch(charSequence, n, 0, charSequence.length());
    }

    default public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
        return this.isMatch(CharSequenceUtils.toCharArray(charSequence), n, n3, n3);
    }

    default public int size() {
        return 0;
    }

    public static final class None
    implements StringMatcher {
        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return 0;
        }

        @Override
        public int size() {
            return 0;
        }
    }

    public static final class And
    implements StringMatcher {
        private final StringMatcher[] matchers;

        public And(StringMatcher ... stringMatcherArray) {
            this.matchers = (StringMatcher[])stringMatcherArray.clone();
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            int n4 = 0;
            int n5 = n;
            for (StringMatcher stringMatcher : this.matchers) {
                if (stringMatcher == null) continue;
                int n6 = stringMatcher.isMatch(cArray, n5, n2, n3);
                if (n6 == 0) {
                    return 0;
                }
                n4 += n6;
                n5 += n6;
            }
            return n4;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            int n4 = 0;
            int n5 = n;
            for (StringMatcher stringMatcher : this.matchers) {
                if (stringMatcher == null) continue;
                int n6 = stringMatcher.isMatch(charSequence, n5, n2, n3);
                if (n6 == 0) {
                    return 0;
                }
                n4 += n6;
                n5 += n6;
            }
            return n4;
        }

        @Override
        public int size() {
            int n = 0;
            for (StringMatcher stringMatcher : this.matchers) {
                if (stringMatcher == null) continue;
                n += stringMatcher.size();
            }
            return n;
        }
    }

    public static final class Char
    implements StringMatcher {
        private final char ch;

        public Char(char c) {
            this.ch = c;
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return this.ch == cArray[n] ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return this.ch == charSequence.charAt(n) ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static class CharSet
    implements StringMatcher {
        private final char[] chars;

        public CharSet(char[] cArray) {
            this.chars = (char[])cArray.clone();
            Arrays.sort(this.chars);
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return Arrays.binarySearch(this.chars, cArray[n]) >= 0 ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return Arrays.binarySearch(this.chars, charSequence.charAt(n)) >= 0 ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }
    }

    public static final class CharArray
    implements StringMatcher {
        private final char[] chars;
        private final String string;

        public CharArray(char ... cArray) {
            this.chars = (char[])cArray.clone();
            this.string = String.valueOf(cArray);
        }

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            int n4 = this.size();
            if (n + n4 > n3) {
                return 0;
            }
            int n5 = n;
            int n6 = 0;
            while (n6 < n4) {
                if (this.chars[n6] != cArray[n5]) {
                    return 0;
                }
                ++n6;
                ++n5;
            }
            return n4;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            int n4 = this.size();
            if (n + n4 > n3) {
                return 0;
            }
            int n5 = n;
            int n6 = 0;
            while (n6 < n4) {
                if (this.chars[n6] != charSequence.charAt(n5)) {
                    return 0;
                }
                ++n6;
                ++n5;
            }
            return n4;
        }

        @Override
        public int size() {
            return this.chars.length;
        }
    }

    public static final class Whitespace
    implements StringMatcher {
        private static final int SPACE_INT = 32;

        @Override
        public int isMatch(char[] cArray, int n, int n2, int n3) {
            return cArray[n] <= ' ' ? 1 : 0;
        }

        @Override
        public int isMatch(CharSequence charSequence, int n, int n2, int n3) {
            return charSequence.charAt(n) <= ' ' ? 1 : 0;
        }

        @Override
        public int size() {
            return 1;
        }
    }
}

