/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.text;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.lang.Nullable;
import spring.turbo.util.text.StringMatcher;
import spring.turbo.util.text.TextStringBuilder;

public class StringTokenizer
implements ListIterator<String>,
Serializable,
Cloneable {
    private static final StringTokenizer CSV_TOKENIZER_PROTOTYPE = new StringTokenizer();
    private static final StringTokenizer TSV_TOKENIZER_PROTOTYPE;
    @Nullable
    private char[] chars;
    @Nullable
    private String[] tokens;
    private int tokenPos = 0;
    private StringMatcher delimMatcher = StringMatcher.splitMatcher();
    private StringMatcher quoteMatcher = StringMatcher.noneMatcher();
    private StringMatcher ignoredMatcher = StringMatcher.noneMatcher();
    private StringMatcher trimmerMatcher = StringMatcher.noneMatcher();
    private boolean emptyAsNull = false;
    private boolean ignoreEmptyTokens = false;

    public StringTokenizer() {
        this.chars = null;
    }

    public StringTokenizer(@Nullable char[] cArray) {
        this.chars = cArray != null ? (char[])cArray.clone() : null;
    }

    public StringTokenizer(@Nullable char[] cArray, char c) {
        this(cArray);
        this.setDelimiterChar(c);
    }

    public StringTokenizer(@Nullable char[] cArray, char c, char c2) {
        this(cArray, c);
        this.setQuoteChar(c2);
    }

    public StringTokenizer(@Nullable char[] cArray, String string) {
        this(cArray);
        this.setDelimiterString(string);
    }

    public StringTokenizer(@Nullable char[] cArray, StringMatcher stringMatcher) {
        this(cArray);
        this.setDelimiterMatcher(stringMatcher);
    }

    public StringTokenizer(@Nullable char[] cArray, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this(cArray, stringMatcher);
        this.setQuoteMatcher(stringMatcher2);
    }

    public StringTokenizer(@Nullable String string) {
        this.chars = string != null ? string.toCharArray() : null;
    }

    public StringTokenizer(@Nullable String string, char c) {
        this(string);
        this.setDelimiterChar(c);
    }

    public StringTokenizer(@Nullable String string, char c, char c2) {
        this(string, c);
        this.setQuoteChar(c2);
    }

    public StringTokenizer(@Nullable String string, String string2) {
        this(string);
        this.setDelimiterString(string2);
    }

    public StringTokenizer(@Nullable String string, StringMatcher stringMatcher) {
        this(string);
        this.setDelimiterMatcher(stringMatcher);
    }

    public StringTokenizer(@Nullable String string, StringMatcher stringMatcher, StringMatcher stringMatcher2) {
        this(string, stringMatcher);
        this.setQuoteMatcher(stringMatcher2);
    }

    private static StringTokenizer getCSVClone() {
        return (StringTokenizer)CSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StringTokenizer getCSVInstance() {
        return StringTokenizer.getCSVClone();
    }

    public static StringTokenizer getCSVInstance(char[] cArray) {
        return StringTokenizer.getCSVClone().reset(cArray);
    }

    public static StringTokenizer getCSVInstance(String string) {
        return StringTokenizer.getCSVClone().reset(string);
    }

    private static StringTokenizer getTSVClone() {
        return (StringTokenizer)TSV_TOKENIZER_PROTOTYPE.clone();
    }

    public static StringTokenizer newInstance(@Nullable char[] cArray) {
        return new StringTokenizer(cArray);
    }

    public static StringTokenizer newInstance(@Nullable String string) {
        return new StringTokenizer(string);
    }

    public static StringTokenizer newInstance() {
        return new StringTokenizer();
    }

    public static StringTokenizer getTSVInstance() {
        return StringTokenizer.getTSVClone();
    }

    public static StringTokenizer getTSVInstance(char[] cArray) {
        return StringTokenizer.getTSVClone().reset(cArray);
    }

    public static StringTokenizer getTSVInstance(String string) {
        return StringTokenizer.getTSVClone().reset(string);
    }

    @Override
    public void add(String string) {
        throw new UnsupportedOperationException("add() is unsupported");
    }

    private void addToken(List<String> list, @Nullable String string) {
        if (string == null || string.isEmpty()) {
            if (this.isIgnoreEmptyTokens()) {
                return;
            }
            if (this.isEmptyTokenAsNull()) {
                string = null;
            }
        }
        list.add(string);
    }

    private void checkTokenized() {
        if (this.tokens == null) {
            List<String> list = this.chars == null ? this.tokenize(null, 0, 0) : this.tokenize(this.chars, 0, this.chars.length);
            this.tokens = list.toArray(new String[0]);
        }
    }

    public Object clone() {
        try {
            return this.cloneReset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    Object cloneReset() throws CloneNotSupportedException {
        StringTokenizer stringTokenizer = (StringTokenizer)super.clone();
        if (stringTokenizer.chars != null) {
            stringTokenizer.chars = (char[])stringTokenizer.chars.clone();
        }
        stringTokenizer.reset();
        return stringTokenizer;
    }

    @Nullable
    public String getContent() {
        if (this.chars == null) {
            return null;
        }
        return new String(this.chars);
    }

    public StringMatcher getDelimiterMatcher() {
        return this.delimMatcher;
    }

    public StringTokenizer setDelimiterMatcher(StringMatcher stringMatcher) {
        this.delimMatcher = stringMatcher;
        return this;
    }

    public StringMatcher getIgnoredMatcher() {
        return this.ignoredMatcher;
    }

    public StringTokenizer setIgnoredMatcher(StringMatcher stringMatcher) {
        this.ignoredMatcher = stringMatcher;
        return this;
    }

    public StringMatcher getQuoteMatcher() {
        return this.quoteMatcher;
    }

    public StringTokenizer setQuoteMatcher(StringMatcher stringMatcher) {
        this.quoteMatcher = stringMatcher;
        return this;
    }

    public StringMatcher getTrimmerMatcher() {
        return this.trimmerMatcher;
    }

    public StringTokenizer setTrimmerMatcher(StringMatcher stringMatcher) {
        this.trimmerMatcher = stringMatcher;
        return this;
    }

    public boolean isEmptyTokenAsNull() {
        return this.emptyAsNull;
    }

    public StringTokenizer setEmptyTokenAsNull(boolean bl) {
        this.emptyAsNull = bl;
        return this;
    }

    public boolean isIgnoreEmptyTokens() {
        return this.ignoreEmptyTokens;
    }

    public StringTokenizer setIgnoreEmptyTokens(boolean bl) {
        this.ignoreEmptyTokens = bl;
        return this;
    }

    public String[] getTokenArray() {
        this.checkTokenized();
        return (String[])this.tokens.clone();
    }

    public String[] getCheckedTokenArray(int n) {
        return this.getCheckedTokenArray(n, () -> new IllegalArgumentException("expect count not match"));
    }

    public String[] getCheckedTokenArray(int n, Supplier<RuntimeException> supplier) {
        this.checkTokenized();
        if (this.tokens.length != n) {
            throw supplier.get();
        }
        return (String[])this.tokens.clone();
    }

    public List<String> getTokenList() {
        this.checkTokenized();
        return Arrays.asList(this.tokens);
    }

    public List<String> getCheckedTokenList(int n) {
        return this.getCheckedTokenList(n, () -> new IllegalArgumentException("expect count not match"));
    }

    public List<String> getCheckedTokenList(int n, Supplier<RuntimeException> supplier) {
        this.checkTokenized();
        if (this.tokens.length != n) {
            throw supplier.get();
        }
        return Arrays.asList(this.tokens);
    }

    public Stream<String> getTokenStream() {
        this.checkTokenized();
        return Stream.of(this.tokens);
    }

    @Override
    public boolean hasNext() {
        this.checkTokenized();
        return this.tokenPos < this.tokens.length;
    }

    @Override
    public boolean hasPrevious() {
        this.checkTokenized();
        return this.tokenPos > 0;
    }

    private boolean isQuote(char[] cArray, int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4; ++i) {
            if (n + i < n2 && cArray[n + i] == cArray[n3 + i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (this.hasNext()) {
            return this.tokens[this.tokenPos++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int nextIndex() {
        return this.tokenPos;
    }

    @Override
    public String previous() {
        if (this.hasPrevious()) {
            return this.tokens[--this.tokenPos];
        }
        throw new NoSuchElementException();
    }

    @Override
    public int previousIndex() {
        return this.tokenPos - 1;
    }

    private int readNextToken(char[] cArray, int n, int n2, TextStringBuilder textStringBuilder, List<String> list) {
        int n3;
        while (n < n2 && (n3 = Math.max(this.getIgnoredMatcher().isMatch(cArray, n, n, n2), this.getTrimmerMatcher().isMatch(cArray, n, n, n2))) != 0 && this.getDelimiterMatcher().isMatch(cArray, n, n, n2) <= 0 && this.getQuoteMatcher().isMatch(cArray, n, n, n2) <= 0) {
            n += n3;
        }
        if (n >= n2) {
            this.addToken(list, "");
            return -1;
        }
        n3 = this.getDelimiterMatcher().isMatch(cArray, n, n, n2);
        if (n3 > 0) {
            this.addToken(list, "");
            return n + n3;
        }
        int n4 = this.getQuoteMatcher().isMatch(cArray, n, n, n2);
        if (n4 > 0) {
            return this.readWithQuotes(cArray, n + n4, n2, textStringBuilder, list, n, n4);
        }
        return this.readWithQuotes(cArray, n, n2, textStringBuilder, list, 0, 0);
    }

    private int readWithQuotes(char[] cArray, int n, int n2, TextStringBuilder textStringBuilder, List<String> list, int n3, int n4) {
        textStringBuilder.clear();
        int n5 = n;
        boolean bl = n4 > 0;
        int n6 = 0;
        while (n5 < n2) {
            if (bl) {
                if (this.isQuote(cArray, n5, n2, n3, n4)) {
                    if (this.isQuote(cArray, n5 + n4, n2, n3, n4)) {
                        textStringBuilder.append(cArray, n5, n4);
                        n5 += n4 * 2;
                        n6 = textStringBuilder.size();
                        continue;
                    }
                    bl = false;
                    n5 += n4;
                    continue;
                }
            } else {
                int n7 = this.getDelimiterMatcher().isMatch(cArray, n5, n, n2);
                if (n7 > 0) {
                    this.addToken(list, textStringBuilder.substring(0, n6));
                    return n5 + n7;
                }
                if (n4 > 0 && this.isQuote(cArray, n5, n2, n3, n4)) {
                    bl = true;
                    n5 += n4;
                    continue;
                }
                int n8 = this.getIgnoredMatcher().isMatch(cArray, n5, n, n2);
                if (n8 > 0) {
                    n5 += n8;
                    continue;
                }
                int n9 = this.getTrimmerMatcher().isMatch(cArray, n5, n, n2);
                if (n9 > 0) {
                    textStringBuilder.append(cArray, n5, n9);
                    n5 += n9;
                    continue;
                }
            }
            textStringBuilder.append(cArray[n5++]);
            n6 = textStringBuilder.size();
        }
        this.addToken(list, textStringBuilder.substring(0, n6));
        return -1;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is unsupported");
    }

    @Override
    public void set(String string) {
        throw new UnsupportedOperationException("set() is unsupported");
    }

    public StringTokenizer reset() {
        this.tokenPos = 0;
        this.tokens = null;
        return this;
    }

    public StringTokenizer reset(@Nullable char[] cArray) {
        this.reset();
        this.chars = cArray != null ? (char[])cArray.clone() : null;
        return this;
    }

    public StringTokenizer reset(@Nullable String string) {
        this.reset();
        this.chars = string != null ? string.toCharArray() : null;
        return this;
    }

    public StringTokenizer setDelimiterChar(char c) {
        return this.setDelimiterMatcher(StringMatcher.charMatcher(c));
    }

    public StringTokenizer setDelimiterString(String string) {
        return this.setDelimiterMatcher(StringMatcher.stringMatcher(string));
    }

    public StringTokenizer setIgnoredChar(char c) {
        return this.setIgnoredMatcher(StringMatcher.charMatcher(c));
    }

    public StringTokenizer setQuoteChar(char c) {
        return this.setQuoteMatcher(StringMatcher.charMatcher(c));
    }

    public int size() {
        this.checkTokenized();
        return this.tokens.length;
    }

    protected List<String> tokenize(@Nullable char[] cArray, int n, int n2) {
        if (cArray == null || n2 == 0) {
            return Collections.emptyList();
        }
        TextStringBuilder textStringBuilder = new TextStringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = n;
        while (n3 >= 0 && n3 < n2) {
            if ((n3 = this.readNextToken(cArray, n3, n2, textStringBuilder, arrayList)) < n2) continue;
            this.addToken(arrayList, "");
        }
        return arrayList;
    }

    static {
        CSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StringMatcher.commaMatcher());
        CSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StringMatcher.doubleQuoteMatcher());
        CSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StringMatcher.noneMatcher());
        CSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StringMatcher.whitespaceMatcher());
        CSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        CSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
        TSV_TOKENIZER_PROTOTYPE = new StringTokenizer();
        TSV_TOKENIZER_PROTOTYPE.setDelimiterMatcher(StringMatcher.tabMatcher());
        TSV_TOKENIZER_PROTOTYPE.setQuoteMatcher(StringMatcher.doubleQuoteMatcher());
        TSV_TOKENIZER_PROTOTYPE.setIgnoredMatcher(StringMatcher.noneMatcher());
        TSV_TOKENIZER_PROTOTYPE.setTrimmerMatcher(StringMatcher.whitespaceMatcher());
        TSV_TOKENIZER_PROTOTYPE.setEmptyTokenAsNull(false);
        TSV_TOKENIZER_PROTOTYPE.setIgnoreEmptyTokens(false);
    }
}

