/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.text;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.lang.Nullable;
import spring.turbo.util.StringUtils;
import spring.turbo.util.text.StringMatcher;
import spring.turbo.util.text.StringTokenizer;

public class TextVariables
extends MutablePropertyValues
implements Serializable {
    private static final StringMatcher DEFAULT_DELIMITER = StringMatcher.charSetMatcher(';', '\n');

    public TextVariables(@Nullable String string) {
        this(string, null);
    }

    public TextVariables(@Nullable String string, @Nullable StringMatcher stringMatcher) {
        this.set(string, stringMatcher);
    }

    public static TextVariables valueOf(@Nullable String string) {
        return new TextVariables(string, null);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.stream().forEach(propertyValue -> hashMap.put(propertyValue.getName(), (String)propertyValue.getValue()));
        return hashMap;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.putAll(this.toMap());
        return properties;
    }

    private void set(@Nullable String string, @Nullable StringMatcher stringMatcher) {
        if (StringUtils.isNotBlank(string)) {
            stringMatcher = stringMatcher != null ? stringMatcher : DEFAULT_DELIMITER;
            StringTokenizer stringTokenizer = StringTokenizer.newInstance(string).setDelimiterMatcher(stringMatcher).setTrimmerMatcher(StringMatcher.noneMatcher());
            while (stringTokenizer.hasNext()) {
                String string2;
                Pattern pattern;
                Matcher matcher;
                String string3 = stringTokenizer.next();
                if (string3.isBlank() || !(matcher = (pattern = Pattern.compile(string2 = "(.*?)=(.*)", 40)).matcher(string3)).matches()) continue;
                String string4 = matcher.group(1).trim();
                String string5 = matcher.group(2).trim();
                super.addPropertyValue(new PropertyValue(string4, (Object)string5));
            }
        }
    }
}

