/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class DateParseUtils {
    private static final String PRIMARY_PATTERN = "yyyy-MM-dd";
    private static final String[] BACKUP_PATTERNS = new String[]{"yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm:ss.SSS", "yyyy/MM/dd", "yyyy-M-d HH:mm:ss", "yyyy-M-d HH:mm:ss.SSS", "yyyy-M-d", "yyyy/M/d HH:mm:ss", "yyyy/M/d HH:mm:ss.SSS", "yyyy/M/d", "yyyy", "yyyy-MM", "yyyy-M"};

    private DateParseUtils() {
    }

    public static Date parse(String string, String string2, String ... stringArray) {
        Assert.hasText((String)string, (String)"string ire required");
        Assert.hasText((String)string2, (String)"pattern is required");
        try {
            DateFormatter dateFormatter = new DateFormatter();
            dateFormatter.setIso(DateTimeFormat.ISO.NONE);
            dateFormatter.setPattern(string2);
            dateFormatter.setFallbackPatterns(stringArray);
            return dateFormatter.parse(string, Locale.getDefault());
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(parseException.getMessage(), parseException);
        }
    }

    public static Date parse(String string, String string2, @Nullable Collection<String> collection) {
        if (collection != null && !collection.isEmpty()) {
            return DateParseUtils.parse(string, string2, collection.toArray(new String[0]));
        }
        return DateParseUtils.parse(string, string2, new String[0]);
    }

    public static Date parseWildly(String string) {
        return DateParseUtils.parse(string, PRIMARY_PATTERN, BACKUP_PATTERNS);
    }
}

