/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.format.datetime.DateFormatter;
import org.springframework.util.Assert;
import spring.turbo.util.StringFormatter;

public final class DateUtils {
    public static final long MILLIS_PER_SECOND = 1000L;
    public static final long MILLIS_PER_MINUTE = 60000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final int SEMI_MONTH = 1001;
    private static final int[][] fields = new int[][]{{14}, {13}, {12}, {11, 10}, {5, 5, 9}, {2, 1001}, {1}, {0}};

    private DateUtils() {
    }

    public static boolean isSameDay(Date date, Date date2) {
        Assert.notNull((Object)date, (String)"date1 is required");
        Assert.notNull((Object)date2, (String)"date2 is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        return DateUtils.isSameDay(calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        Assert.notNull((Object)calendar, (String)"cal1 is required");
        Assert.notNull((Object)calendar2, (String)"cal2 is required");
        return calendar.get(0) == calendar2.get(0) && calendar.get(1) == calendar2.get(1) && calendar.get(6) == calendar2.get(6);
    }

    public static boolean isSameInstant(Date date, Date date2) {
        Assert.notNull((Object)date, (String)"date1 is required");
        Assert.notNull((Object)date2, (String)"date2 is required");
        return date.getTime() == date2.getTime();
    }

    public static boolean isSameInstant(Calendar calendar, Calendar calendar2) {
        Assert.notNull((Object)calendar, (String)"cal1 is required");
        Assert.notNull((Object)calendar2, (String)"cal2 is required");
        return calendar.getTime().getTime() == calendar2.getTime().getTime();
    }

    public static boolean isSameLocalTime(Calendar calendar, Calendar calendar2) {
        Assert.notNull((Object)calendar, (String)"cal1 is required");
        Assert.notNull((Object)calendar2, (String)"cal2 is required");
        return calendar.get(14) == calendar2.get(14) && calendar.get(13) == calendar2.get(13) && calendar.get(12) == calendar2.get(12) && calendar.get(11) == calendar2.get(11) && calendar.get(6) == calendar2.get(6) && calendar.get(1) == calendar2.get(1) && calendar.get(0) == calendar2.get(0) && calendar.getClass() == calendar2.getClass();
    }

    public static Date addYears(Date date, int n) {
        return DateUtils.add(date, 1, n);
    }

    public static Date addMonths(Date date, int n) {
        return DateUtils.add(date, 2, n);
    }

    public static Date addWeeks(Date date, int n) {
        return DateUtils.add(date, 3, n);
    }

    public static Date addDays(Date date, int n) {
        return DateUtils.add(date, 5, n);
    }

    public static Date addHours(Date date, int n) {
        return DateUtils.add(date, 11, n);
    }

    public static Date addMinutes(Date date, int n) {
        return DateUtils.add(date, 12, n);
    }

    public static Date addSeconds(Date date, int n) {
        return DateUtils.add(date, 13, n);
    }

    public static Date addMilliseconds(Date date, int n) {
        return DateUtils.add(date, 14, n);
    }

    private static Date add(Date date, int n, int n2) {
        Assert.notNull((Object)date, (String)"date is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(n, n2);
        return calendar.getTime();
    }

    public static Date setYears(Date date, int n) {
        return DateUtils.set(date, 1, n);
    }

    public static Date setMonths(Date date, int n) {
        return DateUtils.set(date, 2, n);
    }

    public static Date setDays(Date date, int n) {
        return DateUtils.set(date, 5, n);
    }

    public static Date setHours(Date date, int n) {
        return DateUtils.set(date, 11, n);
    }

    public static Date setMinutes(Date date, int n) {
        return DateUtils.set(date, 12, n);
    }

    public static Date setSeconds(Date date, int n) {
        return DateUtils.set(date, 13, n);
    }

    public static Date setMilliseconds(Date date, int n) {
        return DateUtils.set(date, 14, n);
    }

    private static Date set(Date date, int n, int n2) {
        Assert.notNull((Object)date, (String)"date is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTime(date);
        calendar.set(n, n2);
        return calendar.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static LocalDate toLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Year toYear(Date date) {
        return Year.from(DateUtils.toLocalDate(date));
    }

    public static YearMonth toYearMonth(Date date) {
        return YearMonth.from(DateUtils.toLocalDate(date));
    }

    public static Instant toInstant(Date date) {
        return date.toInstant();
    }

    public static Date round(Date date, int n) {
        Assert.notNull((Object)date, (String)"date is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, ModifyType.ROUND);
        return calendar.getTime();
    }

    public static Calendar round(Calendar calendar, int n) {
        Assert.notNull((Object)calendar, (String)"date is required");
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, ModifyType.ROUND);
        return calendar2;
    }

    public static Date truncate(Date date, int n) {
        Assert.notNull((Object)date, (String)"date is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, ModifyType.TRUNCATE);
        return calendar.getTime();
    }

    public static Calendar truncate(Calendar calendar, int n) {
        Assert.notNull((Object)calendar, (String)"date is required");
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, ModifyType.TRUNCATE);
        return calendar2;
    }

    public static Date ceiling(Date date, int n) {
        Assert.notNull((Object)date, (String)"date is required");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        DateUtils.modify(calendar, n, ModifyType.CEILING);
        return calendar.getTime();
    }

    public static Calendar ceiling(Calendar calendar, int n) {
        Assert.notNull((Object)calendar, (String)"date is required");
        Calendar calendar2 = (Calendar)calendar.clone();
        DateUtils.modify(calendar2, n, ModifyType.CEILING);
        return calendar2;
    }

    private static void modify(Calendar calendar, int n, ModifyType modifyType) {
        if (calendar.get(1) > 280000000) {
            throw new ArithmeticException("Calendar value too large for accurate calculations");
        }
        if (n == 14) {
            return;
        }
        Date date = calendar.getTime();
        long l = date.getTime();
        boolean bl = false;
        int n2 = calendar.get(14);
        if (ModifyType.TRUNCATE == modifyType || n2 < 500) {
            l -= (long)n2;
        }
        if (n == 13) {
            bl = true;
        }
        int n3 = calendar.get(13);
        if (!(bl || ModifyType.TRUNCATE != modifyType && n3 >= 30)) {
            l -= (long)n3 * 1000L;
        }
        if (n == 12) {
            bl = true;
        }
        int n4 = calendar.get(12);
        if (!(bl || ModifyType.TRUNCATE != modifyType && n4 >= 30)) {
            l -= (long)n4 * 60000L;
        }
        if (date.getTime() != l) {
            date.setTime(l);
            calendar.setTime(date);
        }
        boolean bl2 = false;
        int[][] nArray = fields;
        int n5 = nArray.length;
        for (int i = 0; i < n5; ++i) {
            int[] nArray2;
            for (int n6 : nArray2 = nArray[i]) {
                if (n6 != n) continue;
                if (modifyType == ModifyType.CEILING || modifyType == ModifyType.ROUND && bl2) {
                    if (n == 1001) {
                        if (calendar.get(5) == 1) {
                            calendar.add(5, 15);
                        } else {
                            calendar.add(5, -15);
                            calendar.add(2, 1);
                        }
                    } else if (n == 9) {
                        if (calendar.get(11) == 0) {
                            calendar.add(11, 12);
                        } else {
                            calendar.add(11, -12);
                            calendar.add(5, 1);
                        }
                    } else {
                        calendar.add(nArray2[0], 1);
                    }
                }
                return;
            }
            int n7 = 0;
            int n8 = 0;
            switch (n) {
                case 1001: {
                    if (nArray2[0] != 5) break;
                    n7 = calendar.get(5) - 1;
                    if (n7 >= 15) {
                        n7 -= 15;
                    }
                    bl2 = n7 > 7;
                    n8 = 1;
                    break;
                }
                case 9: {
                    if (nArray2[0] != 11) break;
                    n7 = calendar.get(11);
                    if (n7 >= 12) {
                        n7 -= 12;
                    }
                    bl2 = n7 >= 6;
                    n8 = 1;
                    break;
                }
            }
            if (n8 == 0) {
                int n6;
                int n9 = calendar.getActualMinimum(nArray2[0]);
                n6 = calendar.getActualMaximum(nArray2[0]);
                n7 = calendar.get(nArray2[0]) - n9;
                boolean bl3 = bl2 = n7 > (n6 - n9) / 2;
            }
            if (n7 == 0) continue;
            calendar.set(nArray2[0], calendar.get(nArray2[0]) - n7);
        }
        throw new IllegalArgumentException("The field " + n + " is not supported");
    }

    public static boolean truncatedEquals(Calendar calendar, Calendar calendar2, int n) {
        return DateUtils.truncatedCompareTo(calendar, calendar2, n) == 0;
    }

    public static boolean truncatedEquals(Date date, Date date2, int n) {
        return DateUtils.truncatedCompareTo(date, date2, n) == 0;
    }

    public static int truncatedCompareTo(Calendar calendar, Calendar calendar2, int n) {
        Calendar calendar3 = DateUtils.truncate(calendar, n);
        Calendar calendar4 = DateUtils.truncate(calendar2, n);
        return calendar3.compareTo(calendar4);
    }

    public static int truncatedCompareTo(Date date, Date date2, int n) {
        Date date3 = DateUtils.truncate(date, n);
        Date date4 = DateUtils.truncate(date2, n);
        return date3.compareTo(date4);
    }

    public static String format(Date date, String string) {
        return new DateFormatter(string).print(date, Locale.getDefault());
    }

    public static String getYearWeek(Date date) {
        return DateUtils.getYearWeek(date, 1, 4);
    }

    public static String getYearWeek(Date date, int n, int n2) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.setFirstDayOfWeek(n);
        calendar.setMinimalDaysInFirstWeek(n2);
        String string = String.format("%d", calendar.getWeekYear());
        String string2 = String.format("%02d", calendar.get(3));
        return StringFormatter.format("{}-{}", string, string2);
    }

    private static enum ModifyType {
        TRUNCATE,
        ROUND,
        CEILING;

    }
}

