/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class DurationParseUtils {
    private DurationParseUtils() {
    }

    public static Duration parse(String string) {
        return DurationParseUtils.parse(string, null);
    }

    public static Duration parse(@NonNull String string, @Nullable ChronoUnit chronoUnit) {
        Assert.hasText((String)string, (String)"string is required");
        Duration duration = DurationParseUtils.parseFromSimpleStyle(string, chronoUnit);
        if (duration == null) {
            duration = DurationParseUtils.parseFromISO8601Style(string, chronoUnit);
        }
        if (duration == null) {
            throw new IllegalArgumentException("'" + string + "' is not a valid duration");
        }
        return duration;
    }

    @Nullable
    private static Duration parseFromSimpleStyle(String string, @Nullable ChronoUnit chronoUnit) {
        try {
            return DurationStyle.SIMPLE.parse(string, chronoUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static Duration parseFromISO8601Style(String string, @Nullable ChronoUnit chronoUnit) {
        try {
            return DurationStyle.ISO8601.parse(string, chronoUnit);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

