/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class LocalDateTimeUtils {
    private LocalDateTimeUtils() {
    }

    public static LocalDateTime toLocalDateTime(Date date, @Nullable ZoneId zoneId) {
        Assert.notNull((Object)date, (String)"date is required");
        return Instant.ofEpochMilli(date.getTime()).atZone(Objects.requireNonNullElse(zoneId, ZoneId.systemDefault())).toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTime(long l, @Nullable ZoneId zoneId) {
        Assert.isTrue((l >= 0L ? 1 : 0) != 0, (String)"timestamp should >= 0");
        return Instant.ofEpochMilli(l).atZone(Objects.requireNonNullElse(zoneId, ZoneId.systemDefault())).toLocalDateTime();
    }
}

