/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import spring.turbo.util.time.Zodiac;

public final class LocalDateUtils {
    private LocalDateUtils() {
    }

    public static Date toDate(LocalDate localDate) {
        return LocalDateUtils.toDate(localDate, null);
    }

    public static Date toDate(LocalDate localDate, @Nullable ZoneId zoneId) {
        zoneId = Objects.requireNonNullElse(zoneId, ZoneId.systemDefault());
        Instant instant = Instant.from(localDate.atStartOfDay(zoneId));
        return Date.from(instant);
    }

    public static LocalDate toLocalDate(Date date) {
        Assert.notNull((Object)date, (String)"date is required");
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static boolean isSameDay(LocalDate localDate, LocalDate localDate2) {
        Assert.notNull((Object)localDate, (String)"date1 is required");
        Assert.notNull((Object)localDate2, (String)"date2 is required");
        return localDate.compareTo(localDate2) == 0;
    }

    public static int distanceDays(LocalDate localDate, LocalDate localDate2) {
        Assert.notNull((Object)localDate, (String)"date1 is required");
        Assert.notNull((Object)localDate2, (String)"date2 is required");
        return (int)Math.abs(ChronoUnit.DAYS.between(localDate, localDate2));
    }

    public static Zodiac zodiac(LocalDate localDate) {
        Assert.notNull((Object)localDate, (String)"date is required");
        return Zodiac.getZodiac(localDate.getMonthValue(), localDate.getDayOfMonth());
    }
}

