/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.util.time;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.lang.Nullable;
import spring.turbo.util.StringUtils;

public final class ZoneIdUtils {
    public static final ZoneId SYSTEM_DEFAULT = ZoneId.systemDefault();
    public static final String EUROPE_LONDON_VALUE = "Europe/London";
    public static final ZoneId EUROPE_LONDON = ZoneId.of("Europe/London");
    public static final String ASIA_SHANGHAI_VALUE = "Asia/Shanghai";
    public static final ZoneId ASIA_SHANGHAI = ZoneId.of("Asia/Shanghai");
    public static final String AMERICA_CHICAGO_VALUE = "America/Chicago";
    public static final ZoneId AMERICA_CHICAGO = ZoneId.of("America/Chicago");
    public static final String ASIA_TOKYO_VALUE = "Asia/Tokyo";
    public static final ZoneId ASIA_TOKYO = ZoneId.of("Asia/Tokyo");

    private ZoneIdUtils() {
    }

    public static ZoneId toZoneIdOrSystemDefault(@Nullable String string) {
        ZoneId zoneId = ZoneIdUtils.toZoneIdOrDefault(string, SYSTEM_DEFAULT);
        return Objects.requireNonNull(zoneId);
    }

    @Nullable
    public static ZoneId toZoneIdOrDefault(@Nullable String string, @Nullable ZoneId zoneId) {
        if (StringUtils.isBlank(string)) {
            return zoneId;
        }
        try {
            return ZoneId.of(string);
        }
        catch (DateTimeException dateTimeException) {
            Matcher matcher = Pattern.compile("^([a-zA-Z]+[+-]\\d+)\\.0+$").matcher(string);
            if (matcher.matches()) {
                string = matcher.replaceAll("$1");
                try {
                    return ZoneId.of(string);
                }
                catch (Throwable throwable) {
                    return zoneId;
                }
            }
            return zoneId;
        }
    }
}

