/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.collector;

import com.github.yizzuide.milkomeda.comet.collector.Collector;
import com.github.yizzuide.milkomeda.comet.collector.CollectorFactory;
import com.github.yizzuide.milkomeda.comet.collector.CollectorRecorder;
import com.github.yizzuide.milkomeda.comet.collector.CometCollectorProperties;
import com.github.yizzuide.milkomeda.comet.collector.CometCollectorResponseBodyAdvice;
import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometConfig;
import com.github.yizzuide.milkomeda.comet.core.CometData;
import com.github.yizzuide.milkomeda.comet.core.CometHolder;
import com.github.yizzuide.milkomeda.pillar.PillarExecutor;
import com.github.yizzuide.milkomeda.universe.polyfill.SpringMvcPolyfill;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.method.support.HandlerMethodReturnValueHandlerComposite;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
@AutoConfigureAfter(value={CometConfig.class})
@EnableConfigurationProperties(value={CometCollectorProperties.class})
@ConditionalOnProperty(prefix="milkomeda.comet.collector", name={"enable"}, havingValue="true")
public class CometCollectorConfig
implements ApplicationContextAware {
    @Autowired
    private CometCollectorProperties props;
    @Autowired(required=false)
    private List<Collector> collectors;

    @Bean
    public CollectorFactory collectorFactory() {
        PillarExecutor<CometData, Object> pillarExecutor = new PillarExecutor<CometData, Object>();
        if (!CollectionUtils.isEmpty(this.collectors)) {
            pillarExecutor.addPillarList(this.collectors.stream().filter(c -> StringUtils.hasLength((String)c.supportType())).collect(Collectors.toList()));
        }
        return new CollectorFactory(pillarExecutor);
    }

    @Bean
    public CollectorRecorder collectorRecorder() {
        return new CollectorRecorder(this.collectorFactory());
    }

    @Autowired
    public void config(CometAspect cometAspect, CometCollectorProperties cometCollectorProperties) {
        cometAspect.setRecorder(this.collectorRecorder());
        CometHolder.setCollectorProps(cometCollectorProperties);
    }

    @Bean
    @ConditionalOnProperty(prefix="milkomeda.comet.collector", name={"enable-tag"}, havingValue="true")
    public CometCollectorResponseBodyAdvice cometResponseBodyAdvice() {
        return new CometCollectorResponseBodyAdvice();
    }

    @Autowired
    public void configResponseBodyAdvice(RequestMappingHandlerAdapter adapter, HandlerExceptionResolver handlerExceptionResolver) {
        if (!this.props.isEnableTag()) {
            return;
        }
        CometCollectorResponseBodyAdvice collectorResponseBodyAdvice = this.cometResponseBodyAdvice();
        SpringMvcPolyfill.addDynamicResponseBodyAdvice(adapter.getReturnValueHandlers(), collectorResponseBodyAdvice);
        if (handlerExceptionResolver instanceof HandlerExceptionResolverComposite) {
            List exceptionResolvers = ((HandlerExceptionResolverComposite)handlerExceptionResolver).getExceptionResolvers();
            if (CollectionUtils.isEmpty((Collection)exceptionResolvers)) {
                return;
            }
            for (HandlerExceptionResolver exceptionResolver : exceptionResolvers) {
                if (!(exceptionResolver instanceof ExceptionHandlerExceptionResolver)) continue;
                HandlerMethodReturnValueHandlerComposite returnValueHandlerComposite = ((ExceptionHandlerExceptionResolver)exceptionResolver).getReturnValueHandlers();
                if (returnValueHandlerComposite == null) {
                    return;
                }
                SpringMvcPolyfill.addDynamicResponseBodyAdvice(returnValueHandlerComposite.getHandlers(), collectorResponseBodyAdvice);
            }
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (CollectionUtils.isEmpty(this.collectors)) {
            this.collectors = new ArrayList(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, Collector.class).values());
            if (CollectionUtils.isEmpty(this.collectors)) {
                return;
            }
            ((CollectorFactory)applicationContext.getBean(CollectorFactory.class)).getPillarExecutor().addPillarList(this.collectors.stream().filter(c -> StringUtils.hasLength((String)c.supportType())).collect(Collectors.toList()));
        }
    }
}

