/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.comet.core.Comet;
import com.github.yizzuide.milkomeda.comet.core.CometData;
import com.github.yizzuide.milkomeda.comet.core.CometHolder;
import com.github.yizzuide.milkomeda.comet.core.CometProperties;
import com.github.yizzuide.milkomeda.comet.core.CometRecorder;
import com.github.yizzuide.milkomeda.comet.core.CometResponseWrapper;
import com.github.yizzuide.milkomeda.comet.core.CometX;
import com.github.yizzuide.milkomeda.comet.core.WebCometData;
import com.github.yizzuide.milkomeda.comet.core.XCometData;
import com.github.yizzuide.milkomeda.universe.config.MilkomedaProperties;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import com.github.yizzuide.milkomeda.util.NetworkUtil;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.util.WebUtils;

@Aspect
@Order(value=-99)
public class CometAspect {
    private static final Logger log = LoggerFactory.getLogger(CometAspect.class);
    @Autowired
    private MilkomedaProperties milkomedaProperties;
    @Autowired
    private CometProperties cometProperties;
    static ThreadLocal<String> resolveThreadLocal = new ThreadLocal();
    private static final ThreadLocal<CometData> threadLocal = new ThreadLocal();
    private static final ThreadLocal<CometData> threadLocalX = new ThreadLocal();
    private final List<Class<?>> ignoreParams;
    private CometRecorder recorder = new CometRecorder(){};

    public CometAspect() {
        this.ignoreParams = new ArrayList();
        this.ignoreParams.addAll(Arrays.asList(CometData.class, InputStream.class, OutputStream.class, ServletRequest.class, ServletResponse.class));
    }

    @Pointcut(value="@annotation(com.github.yizzuide.milkomeda.comet.core.Comet)")
    public void comet() {
    }

    @Pointcut(value="@annotation(com.github.yizzuide.milkomeda.comet.core.CometX)")
    public void cometX() {
    }

    @Around(value="comet()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Date requestTime = new Date();
        Comet comet = ReflectUtil.getAnnotation((JoinPoint)joinPoint, Comet.class);
        HttpServletRequest request = WebContext.getRequest();
        WebCometData cometData = WebCometData.createFormRequest(request, comet.prototype(), this.cometProperties.isEnableReadRequestBody());
        cometData.setApiCode(comet.apiCode());
        cometData.setDescription(StringUtils.isEmpty((Object)comet.name()) ? comet.description() : comet.name());
        cometData.setRequestType(comet.requestType());
        return this.applyAround(cometData, threadLocal, joinPoint, request, requestTime, comet.name(), comet.tag(), returnData -> {
            if (returnData.getClass() == DeferredResult.class) {
                return "[DeferredResult]";
            }
            if (returnData.getClass() == WebAsyncTask.class) {
                return "[WebAsyncTask]";
            }
            return returnData;
        });
    }

    @AfterThrowing(pointcut="comet()", throwing="e")
    public void afterThrowing(Exception e) {
        this.applyAfterThrowing(e, threadLocal);
    }

    @Around(value="cometX()")
    public Object aroundX(ProceedingJoinPoint joinPoint) throws Throwable {
        Date requestTime = new Date();
        CometX comet = ReflectUtil.getAnnotation((JoinPoint)joinPoint, CometX.class);
        XCometData cometData = comet.prototype().newInstance();
        return this.applyAround(cometData, threadLocalX, joinPoint, null, requestTime, comet.name(), comet.tag(), null);
    }

    @AfterThrowing(pointcut="cometX()", throwing="e")
    public void afterThrowingX(Exception e) {
        this.applyAfterThrowing(e, threadLocalX);
    }

    private void applyAfterThrowing(Exception e, ThreadLocal<CometData> threadLocal) {
        CometData cometData = threadLocal.get();
        Date now = new Date();
        long duration = now.getTime() - cometData.getRequestTime().getTime();
        cometData.setStatus(this.cometProperties.getStatusFailCode());
        cometData.setResponseTime(now);
        cometData.setResponseData(null);
        cometData.setDuration(String.valueOf(duration));
        cometData.setErrorInfo(e.getMessage());
        StackTraceElement[] stackTrace = e.getStackTrace();
        if (stackTrace.length > 0) {
            String errorStack = String.format("exception happened: %s \n invoke root: %s", stackTrace[0], stackTrace[stackTrace.length - 1]);
            cometData.setTraceStack(errorStack);
        }
        this.recorder.onThrowing(cometData, e);
        threadLocal.remove();
    }

    private Object applyAround(CometData cometData, ThreadLocal<CometData> threadLocal, ProceedingJoinPoint joinPoint, HttpServletRequest request, Date requestTime, String name, String tag, Function<Object, Object> mapReturnData) throws Throwable {
        CometResponseWrapper responseWrapper;
        cometData.setRequest(request);
        cometData.setRequestTime(requestTime);
        cometData.setName(name);
        cometData.setTag(tag);
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        cometData.setClazzName(signature.getDeclaringTypeName());
        cometData.setExecMethod(signature.getName());
        HashMap<String, Object> params = new HashMap<String, Object>();
        String[] parameterNames = signature.getParameterNames();
        Object[] args = joinPoint.getArgs();
        if (args != null && args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                String argName = parameterNames[i];
                Object argValue = args[i];
                if (this.hasFilter(argValue)) continue;
                params.put(argName, argValue);
            }
            cometData.setRequestData(JSONUtil.serialize(params));
        }
        try {
            String host = NetworkUtil.getHost();
            cometData.setHost(host);
        }
        catch (UnknownHostException host) {
            // empty catch block
        }
        if (this.milkomedaProperties.isShowLog()) {
            log.info("Comet:- before: {}", (Object)JSONUtil.serialize(cometData));
        }
        this.recorder.onRequest(cometData, cometData.getTag(), request, args);
        threadLocal.set(cometData);
        Object returnData = joinPoint.proceed();
        long duration = new Date().getTime() - cometData.getRequestTime().getTime();
        cometData.setDuration(String.valueOf(duration));
        cometData.setStatus(this.cometProperties.getStatusSuccessCode());
        cometData.setResponseTime(new Date());
        if (returnData != null) {
            if (mapReturnData != null) {
                returnData = mapReturnData.apply(returnData);
            }
            if (returnData instanceof ResponseEntity) {
                Object body = ((ResponseEntity)returnData).getBody();
                cometData.setResponseData(body instanceof String ? (String)body : JSONUtil.serialize(body));
            } else {
                cometData.setResponseData(returnData instanceof String ? (String)returnData : JSONUtil.serialize(returnData));
            }
        } else if (CometHolder.getCollectorProps() != null && CometHolder.getCollectorProps().isEnable() && (responseWrapper = (CometResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)WebContext.getResponse(), CometResponseWrapper.class))) != null) {
            cometData.setStatus(WebContext.getResponse().getStatus() == HttpStatus.OK.value() ? this.cometProperties.getStatusSuccessCode() : this.cometProperties.getStatusFailCode());
            String content = new String(responseWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
            cometData.setResponseData(content);
        }
        Object returnObj = this.recorder.onReturn(cometData, returnData);
        Object object = returnObj = returnObj == null ? returnData : returnObj;
        if (this.milkomedaProperties.isShowLog()) {
            log.info("Comet:- afterReturn: {}", (Object)JSONUtil.serialize(cometData));
        }
        threadLocal.remove();
        return returnObj;
    }

    private boolean hasFilter(Object arg) {
        for (Class<?> ignoreParam : this.ignoreParams) {
            if (!ignoreParam.isInstance(arg)) continue;
            return true;
        }
        return false;
    }

    public static WebCometData getCurrentWebCometData() {
        return (WebCometData)threadLocal.get();
    }

    public static XCometData getCurrentXCometData() {
        return (XCometData)threadLocalX.get();
    }

    public void addFilterClass(Class<?> ... clazzList) {
        this.ignoreParams.addAll(Arrays.asList(clazzList));
    }

    public CometRecorder getRecorder() {
        return this.recorder;
    }

    public void setRecorder(CometRecorder recorder) {
        this.recorder = recorder;
    }
}

