/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometHolder;
import com.github.yizzuide.milkomeda.comet.core.CometInterceptor;
import com.github.yizzuide.milkomeda.comet.core.CometParamResolver;
import com.github.yizzuide.milkomeda.comet.core.CometProperties;
import com.github.yizzuide.milkomeda.comet.core.CometRequestFilter;
import com.github.yizzuide.milkomeda.pulsar.PulsarConfig;
import com.github.yizzuide.milkomeda.universe.config.MilkomedaProperties;
import com.github.yizzuide.milkomeda.universe.polyfill.SpringMvcPolyfill;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@AutoConfigureAfter(value={PulsarConfig.class})
@EnableConfigurationProperties(value={MilkomedaProperties.class, CometProperties.class})
public class CometConfig {
    @Autowired
    CometProperties cometProperties;

    @Autowired
    public void config(CometProperties cometProperties) {
        CometHolder.setProps(cometProperties);
    }

    @Bean
    public CometAspect cometAspect() {
        return new CometAspect();
    }

    @Bean
    @ConditionalOnProperty(prefix="milkomeda.comet", name={"enable-read-request-body"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<CometRequestFilter> cometRequestFilter() {
        FilterRegistrationBean cometRequestFilter = new FilterRegistrationBean();
        cometRequestFilter.setFilter((Filter)new CometRequestFilter());
        cometRequestFilter.setName("cometRequestFilter");
        cometRequestFilter.setUrlPatterns(Collections.singleton("/*"));
        cometRequestFilter.setOrder(Integer.MIN_VALUE);
        return cometRequestFilter;
    }

    @Autowired
    public void configParamResolve(RequestMappingHandlerAdapter adapter) {
        ArrayList<CometParamResolver> argumentResolvers = new ArrayList<CometParamResolver>();
        argumentResolvers.add(new CometParamResolver());
        argumentResolvers.addAll(Objects.requireNonNull(adapter.getArgumentResolvers()));
        adapter.setArgumentResolvers(argumentResolvers);
    }

    @Autowired
    public void configRequestMappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        SpringMvcPolyfill.addDynamicInterceptor((HandlerInterceptor)this.cometInterceptor(), Integer.MIN_VALUE, Collections.singletonList("/**"), null, (AbstractHandlerMapping)requestMappingHandlerMapping);
    }

    @Bean
    public CometInterceptor cometInterceptor() {
        return new CometInterceptor();
    }
}

