/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.comet.collector.CometCollectorProperties;
import com.github.yizzuide.milkomeda.comet.collector.TagCollector;
import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometData;
import com.github.yizzuide.milkomeda.comet.core.CometProperties;
import com.github.yizzuide.milkomeda.comet.core.CometResponseWrapper;
import com.github.yizzuide.milkomeda.comet.core.WebCometData;
import com.github.yizzuide.milkomeda.comet.logger.CometLoggerProperties;
import com.github.yizzuide.milkomeda.pulsar.PulsarHolder;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPathMatcher;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPlaceholderParser;
import com.github.yizzuide.milkomeda.universe.parser.url.URLPlaceholderResolver;
import com.github.yizzuide.milkomeda.universe.parser.yml.YmlAliasNode;
import com.github.yizzuide.milkomeda.universe.parser.yml.YmlParser;
import com.github.yizzuide.milkomeda.util.DataTypeConvertUtil;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import com.github.yizzuide.milkomeda.util.NetworkUtil;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.WebUtils;

public class CometInterceptor
extends HandlerInterceptorAdapter
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(CometInterceptor.class);
    @Autowired
    private CometProperties cometProperties;
    @Autowired(required=false)
    private CometCollectorProperties cometCollectorProperties;
    @Autowired(required=false)
    private CometLoggerProperties cometLoggerProperties;
    @Autowired(required=false)
    @Qualifier(value="cometLoggerURLPlaceholderResolver")
    private URLPlaceholderResolver cometLoggerURLPlaceholderResolver;
    private URLPlaceholderParser urlPlaceholderParser;
    private List<CometLoggerProperties.Strategy> strategyList;
    private static ThreadLocal<CometData> threadLocal;
    private Map<String, TagCollector> tagCollectorMap;
    private Map<String, Map<String, YmlAliasNode>> aliasNodesMap;

    @PostConstruct
    public void init() {
        CometLoggerProperties logger = this.cometLoggerProperties;
        if (logger == null) {
            return;
        }
        this.urlPlaceholderParser = new URLPlaceholderParser(logger.getPrefix(), logger.getSuffix());
        this.urlPlaceholderParser.setCustomURLPlaceholderResolver(this.cometLoggerURLPlaceholderResolver);
        List<CometLoggerProperties.Strategy> strategyList = logger.getStrategy();
        if (CollectionUtils.isEmpty(strategyList)) {
            return;
        }
        this.strategyList = strategyList.stream().peek(s -> {
            if (CollectionUtils.containsAny(s.getPaths(), URLPathMatcher.getMatchWildSymbols())) {
                s.setPaths(URLPathMatcher.getWildSymbols());
            }
            Map<String, List<String>> placeHolders = s.getCacheKeys() == null ? this.urlPlaceholderParser.grabPlaceHolders(s.getTpl()) : s.getCacheKeys();
            s.setCacheKeys(placeHolders);
        }).sorted((s1, s2) -> {
            if (CollectionUtils.containsAny(s1.getPaths(), URLPathMatcher.getMatchWildSymbols())) {
                return 1;
            }
            if (CollectionUtils.containsAny(s2.getPaths(), URLPathMatcher.getMatchWildSymbols())) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.cometCollectorProperties == null || !this.cometCollectorProperties.isEnableTag()) {
            return;
        }
        Map<String, CometCollectorProperties.Tag> tagMap = this.cometCollectorProperties.getTags();
        this.tagCollectorMap = tagMap.keySet().stream().collect(Collectors.toMap(Object::toString, tagName -> (TagCollector)applicationContext.getBean(tagName, TagCollector.class)));
        this.aliasNodesMap = new HashMap<String, Map<String, YmlAliasNode>>();
        for (Map.Entry<String, CometCollectorProperties.Tag> tagCollectorEntry : this.cometCollectorProperties.getTags().entrySet()) {
            Map<String, Object> exceptionMonitor = tagCollectorEntry.getValue().getExceptionMonitor();
            if (CollectionUtils.isEmpty(exceptionMonitor)) continue;
            String tag = tagCollectorEntry.getKey();
            this.aliasNodesMap.put(tag, YmlParser.parseAliasMap(exceptionMonitor));
        }
        threadLocal = new ThreadLocal();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.cometLoggerProperties != null) {
            PulsarHolder.getPulsar().post(() -> this.printLog(request));
        }
        if (this.cometCollectorProperties != null && this.cometCollectorProperties.isEnableTag() && !CollectionUtils.isEmpty(this.tagCollectorMap)) {
            this.collectPreLog(request);
        }
        return super.preHandle(request, response, handler);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        CometResponseWrapper responseWrapper;
        if (this.cometCollectorProperties == null || !this.cometCollectorProperties.isEnableTag() || CollectionUtils.isEmpty(this.tagCollectorMap) || threadLocal.get() == null) {
            return;
        }
        Map<String, Object> body = request.getAttribute("comet.collect.body");
        if (body == null && (responseWrapper = (CometResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)response, CometResponseWrapper.class))) != null) {
            String contentType;
            String content = new String(responseWrapper.getContentAsByteArray(), StandardCharsets.UTF_8);
            body = StringUtils.isEmpty((Object)content) ? null : ((contentType = responseWrapper.getResponse().getContentType()).startsWith("application/json") ? JSONUtil.parseMap(content, String.class, Object.class) : content);
        }
        this.collectPostLog(response.getStatus(), body, ex);
    }

    private void collectPostLog(int status, Object body, Exception ex) {
        CometData cometData = threadLocal.get();
        Date now = new Date();
        long duration = now.getTime() - cometData.getRequestTime().getTime();
        cometData.setDuration(String.valueOf(duration));
        cometData.setResponseTime(now);
        String tag = cometData.getTag();
        TagCollector tagCollector = this.tagCollectorMap.get(tag);
        if (ex != null) {
            cometData.setStatus(this.cometProperties.getStatusFailCode());
            cometData.setResponseData(null);
            cometData.setErrorInfo(ex.getMessage());
            StackTraceElement[] stackTrace = ex.getStackTrace();
            if (stackTrace.length > 0) {
                String errorStack = String.format("exception happened: %s \n invoke root: %s", stackTrace[0], stackTrace[stackTrace.length - 1]);
                cometData.setTraceStack(errorStack);
            }
            tagCollector.onFailure(cometData);
            threadLocal.remove();
            return;
        }
        Object failure = cometData.getFailure();
        if (failure != null && failure instanceof Exception) {
            cometData.setStatus(this.cometProperties.getStatusFailCode());
            cometData.setResponseData(body == null ? null : JSONUtil.serialize(body));
            ex = (Exception)failure;
            cometData.setErrorInfo(ex.getMessage());
            StackTraceElement[] stackTrace = ex.getStackTrace();
            String errorStack = String.format("exception happened: %s \n invoke root: %s", stackTrace[0], stackTrace[stackTrace.length - 1]);
            cometData.setTraceStack(errorStack);
            tagCollector.onFailure(cometData);
            threadLocal.remove();
            return;
        }
        if (status >= 400) {
            cometData.setStatus(this.cometProperties.getStatusFailCode());
            cometData.setResponseData(body == null ? null : JSONUtil.serialize(body));
            tagCollector.onFailure(cometData);
            threadLocal.remove();
            return;
        }
        if (body == null) {
            cometData.setStatus(this.cometProperties.getStatusSuccessCode());
            cometData.setResponseData(null);
            tagCollector.onSuccess(cometData);
            threadLocal.remove();
            return;
        }
        Map bodyMap = null;
        boolean isResponseOk = true;
        Map<String, YmlAliasNode> aliasNodes = this.aliasNodesMap.get(tag);
        if (!CollectionUtils.isEmpty(aliasNodes)) {
            if (body instanceof String) {
                isResponseOk = true;
            } else {
                if (!(body instanceof Map)) {
                    body = DataTypeConvertUtil.beanToMap(body);
                }
                bodyMap = body;
                YmlAliasNode ignoreCodeNode = aliasNodes.get("ignore-code");
                Object code = bodyMap.get(ignoreCodeNode.getKey());
                isResponseOk = String.valueOf(code).equals(String.valueOf(ignoreCodeNode.getValue()));
            }
        }
        if (!isResponseOk) {
            cometData.setStatus(this.cometProperties.getStatusFailCode());
            cometData.setResponseData(null);
            Object errorStatckMsg = null;
            Object errorStack = null;
            if (bodyMap != null) {
                YmlAliasNode errorStatckMsgNode = aliasNodes.get("error-stack-msg");
                cometData.setErrorInfo(errorStatckMsgNode == null ? null : DataTypeConvertUtil.extractValue(errorStatckMsgNode.getKey(), bodyMap));
                YmlAliasNode errorStackNode = aliasNodes.get("error-stack");
                cometData.setTraceStack(errorStackNode == null ? null : DataTypeConvertUtil.extractValue(errorStackNode.getKey(), bodyMap));
            }
            tagCollector.onFailure(cometData);
        } else {
            cometData.setStatus(this.cometProperties.getStatusSuccessCode());
            cometData.setResponseData(body instanceof String ? body.toString() : JSONUtil.serialize(body));
            tagCollector.onSuccess(cometData);
        }
        threadLocal.remove();
    }

    private void collectPreLog(HttpServletRequest request) {
        String selectTag = null;
        Map<String, CometCollectorProperties.Tag> tagMap = this.cometCollectorProperties.getTags();
        for (Map.Entry<String, CometCollectorProperties.Tag> tag : tagMap.entrySet()) {
            if (!CollectionUtils.isEmpty(tag.getValue().getExclude()) && URLPathMatcher.match(tag.getValue().getExclude(), request.getRequestURI()) || !URLPathMatcher.match(tag.getValue().getInclude(), request.getRequestURI())) continue;
            selectTag = tag.getKey();
            break;
        }
        if (selectTag == null) {
            return;
        }
        Date requestTime = new Date();
        WebCometData cometData = WebCometData.createFormRequest(request, tagMap.get(selectTag).getPrototype(), this.cometProperties.isEnableReadRequestBody());
        cometData.setRequest(request);
        cometData.setRequestTime(requestTime);
        try {
            String host = NetworkUtil.getHost();
            cometData.setHost(host);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        cometData.setTag(selectTag);
        this.tagCollectorMap.get(selectTag).prepare(cometData);
        threadLocal.set(cometData);
    }

    private void printLog(HttpServletRequest request) {
        CometLoggerProperties logger = this.cometLoggerProperties;
        List<String> exclude = logger.getExclude();
        String requestURI = request.getRequestURI();
        if (!CollectionUtils.isEmpty(exclude) && exclude.contains(requestURI)) {
            return;
        }
        List<CometLoggerProperties.Strategy> strategyList = this.strategyList;
        if (CollectionUtils.isEmpty(strategyList)) {
            return;
        }
        String requestParams = CometAspect.resolveThreadLocal.get();
        for (CometLoggerProperties.Strategy strategy : strategyList) {
            if (CollectionUtils.isEmpty(strategy.getPaths()) || !URLPathMatcher.match(strategy.getPaths(), requestURI)) continue;
            log.info(this.urlPlaceholderParser.parse(strategy.getTpl(), request, requestParams, strategy.getCacheKeys()));
            break;
        }
    }

    public static WebCometData getWebCometData() {
        if (threadLocal == null) {
            return null;
        }
        return (WebCometData)threadLocal.get();
    }
}

