/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometHolder;
import com.github.yizzuide.milkomeda.comet.core.CometRequestWrapper;
import com.github.yizzuide.milkomeda.comet.core.CometResponseWrapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.util.WebUtils;

public class CometRequestFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CometRequestFilter.class);

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean enableAddResponseWrapper;
        Object requestWrapper = servletRequest;
        if (CollectionUtils.isEmpty((Map)servletRequest.getParameterMap())) {
            requestWrapper = new CometRequestWrapper((HttpServletRequest)servletRequest);
        }
        boolean bl = enableAddResponseWrapper = CometHolder.getProps().isEnableReadResponseBody() && CometHolder.getCollectorProps() != null && CometHolder.getCollectorProps().isEnableTag();
        if (enableAddResponseWrapper) {
            servletResponse = new CometResponseWrapper((HttpServletResponse)servletResponse);
        }
        filterChain.doFilter(requestWrapper, servletResponse);
        if (enableAddResponseWrapper) {
            this.updateResponse((HttpServletResponse)servletResponse);
        }
        CometAspect.resolveThreadLocal.remove();
    }

    private void updateResponse(HttpServletResponse response) throws IOException {
        CometResponseWrapper responseWrapper = (CometResponseWrapper)((Object)WebUtils.getNativeResponse((ServletResponse)response, CometResponseWrapper.class));
        Assert.notNull((Object)((Object)responseWrapper), (String)"CometResponseWrapper not found");
        responseWrapper.copyBodyToResponse();
    }

    public void destroy() {
    }
}

