/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.util.HttpServletUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class CometRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(CometRequestWrapper.class);
    private final byte[] body;

    public CometRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        String bodyStr = this.getBodyString((ServletRequest)request);
        if (StringUtils.isEmpty((CharSequence)bodyStr)) {
            this.body = new byte[0];
            return;
        }
        this.body = bodyStr.getBytes(Charset.defaultCharset());
    }

    public static String resolveRequestParams(HttpServletRequest request, boolean formBody) {
        String requestData = HttpServletUtil.getRequestData(request);
        if (formBody && "{}".equals(requestData)) {
            CometRequestWrapper requestWrapper = (CometRequestWrapper)((Object)WebUtils.getNativeRequest((ServletRequest)request, CometRequestWrapper.class));
            if (requestWrapper == null) {
                return requestData;
            }
            String body = requestWrapper.getBodyString();
            body = body == null ? "" : body.replaceAll("\\n?\\t?", "");
            return body;
        }
        return requestData;
    }

    public String getBodyString(ServletRequest request) {
        try {
            return this.inputStream2String((InputStream)request.getInputStream());
        }
        catch (IOException e) {
            log.error("Comet get input stream error:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public String getBodyString() {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return this.inputStream2String(inputStream);
    }

    private String inputStream2String(InputStream inputStream) {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            if (inputStream == null || inputStream.available() == 0) {
                String string = null;
                return string;
            }
            reader = new BufferedReader(new InputStreamReader(inputStream, Charset.defaultCharset()));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (SocketTimeoutException | ClientAbortException ignore) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            log.error("Comet read input stream error:{}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error("Comet close input stream error:{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return sb.toString();
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() throws IOException {
                if (CometRequestWrapper.this.body.length == 0) {
                    return -1;
                }
                return inputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }
        };
    }
}

