/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.comet.core;

import com.github.yizzuide.milkomeda.comet.core.CometAspect;
import com.github.yizzuide.milkomeda.comet.core.CometData;
import com.github.yizzuide.milkomeda.comet.core.CometRequestWrapper;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import com.github.yizzuide.milkomeda.util.NetworkUtil;
import java.util.Enumeration;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebCometData
extends CometData {
    private static final Logger log = LoggerFactory.getLogger(WebCometData.class);
    private static final long serialVersionUID = -2078666744044889106L;
    private String apiCode;
    private String requestType;
    private String requestURL;
    private String requestPath;
    private String requestMethod;
    private String requestParams;
    private String requestHeaders;
    private String requestIP;
    private String deviceInfo;

    public static WebCometData createFormRequest(HttpServletRequest request, Class<? extends WebCometData> prototype, boolean readRequestBody) {
        WebCometData cometData;
        try {
            cometData = prototype == null ? new WebCometData() : prototype.newInstance();
        }
        catch (Exception e) {
            log.info("Comet create WebCometData error with msg: {}", (Object)e.getMessage(), (Object)e);
            throw new IllegalArgumentException("Comet create WebCometData from prototype: " + prototype + " error");
        }
        cometData.setRequestURL(request.getRequestURL().toString());
        cometData.setRequestPath(request.getRequestURI());
        cometData.setRequestMethod(request.getMethod());
        String requestParams = CometAspect.resolveThreadLocal.get();
        cometData.setRequestParams(requestParams != null ? requestParams : CometRequestWrapper.resolveRequestParams(request, readRequestBody));
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            headers.put(key, request.getHeader(key));
        }
        cometData.setRequestHeaders(JSONUtil.serialize(headers));
        cometData.setRequestIP(NetworkUtil.getRemoteAddr(request));
        cometData.setDeviceInfo(request.getHeader("user-agent"));
        return cometData;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public String getRequestParams() {
        return this.requestParams;
    }

    public String getRequestHeaders() {
        return this.requestHeaders;
    }

    public String getRequestIP() {
        return this.requestIP;
    }

    public String getDeviceInfo() {
        return this.deviceInfo;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public void setRequestPath(String requestPath) {
        this.requestPath = requestPath;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public void setRequestParams(String requestParams) {
        this.requestParams = requestParams;
    }

    public void setRequestHeaders(String requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setRequestIP(String requestIP) {
        this.requestIP = requestIP;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebCometData)) {
            return false;
        }
        WebCometData other = (WebCometData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$apiCode = this.getApiCode();
        String other$apiCode = other.getApiCode();
        if (this$apiCode == null ? other$apiCode != null : !this$apiCode.equals(other$apiCode)) {
            return false;
        }
        String this$requestType = this.getRequestType();
        String other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        String this$requestURL = this.getRequestURL();
        String other$requestURL = other.getRequestURL();
        if (this$requestURL == null ? other$requestURL != null : !this$requestURL.equals(other$requestURL)) {
            return false;
        }
        String this$requestPath = this.getRequestPath();
        String other$requestPath = other.getRequestPath();
        if (this$requestPath == null ? other$requestPath != null : !this$requestPath.equals(other$requestPath)) {
            return false;
        }
        String this$requestMethod = this.getRequestMethod();
        String other$requestMethod = other.getRequestMethod();
        if (this$requestMethod == null ? other$requestMethod != null : !this$requestMethod.equals(other$requestMethod)) {
            return false;
        }
        String this$requestParams = this.getRequestParams();
        String other$requestParams = other.getRequestParams();
        if (this$requestParams == null ? other$requestParams != null : !this$requestParams.equals(other$requestParams)) {
            return false;
        }
        String this$requestHeaders = this.getRequestHeaders();
        String other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !this$requestHeaders.equals(other$requestHeaders)) {
            return false;
        }
        String this$requestIP = this.getRequestIP();
        String other$requestIP = other.getRequestIP();
        if (this$requestIP == null ? other$requestIP != null : !this$requestIP.equals(other$requestIP)) {
            return false;
        }
        String this$deviceInfo = this.getDeviceInfo();
        String other$deviceInfo = other.getDeviceInfo();
        return !(this$deviceInfo == null ? other$deviceInfo != null : !this$deviceInfo.equals(other$deviceInfo));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebCometData;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $apiCode = this.getApiCode();
        result = result * 59 + ($apiCode == null ? 43 : $apiCode.hashCode());
        String $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        String $requestURL = this.getRequestURL();
        result = result * 59 + ($requestURL == null ? 43 : $requestURL.hashCode());
        String $requestPath = this.getRequestPath();
        result = result * 59 + ($requestPath == null ? 43 : $requestPath.hashCode());
        String $requestMethod = this.getRequestMethod();
        result = result * 59 + ($requestMethod == null ? 43 : $requestMethod.hashCode());
        String $requestParams = this.getRequestParams();
        result = result * 59 + ($requestParams == null ? 43 : $requestParams.hashCode());
        String $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : $requestHeaders.hashCode());
        String $requestIP = this.getRequestIP();
        result = result * 59 + ($requestIP == null ? 43 : $requestIP.hashCode());
        String $deviceInfo = this.getDeviceInfo();
        result = result * 59 + ($deviceInfo == null ? 43 : $deviceInfo.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "WebCometData(super=" + super.toString() + ", apiCode=" + this.getApiCode() + ", requestType=" + this.getRequestType() + ", requestURL=" + this.getRequestURL() + ", requestPath=" + this.getRequestPath() + ", requestMethod=" + this.getRequestMethod() + ", requestParams=" + this.getRequestParams() + ", requestIP=" + this.getRequestIP() + ")";
    }
}

