/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustAuthenticationToken;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.crust.CrustTokenMetaData;
import com.github.yizzuide.milkomeda.crust.CrustUserDetails;
import com.github.yizzuide.milkomeda.crust.CrustUserDetailsService;
import com.github.yizzuide.milkomeda.crust.CrustUserInfo;
import com.github.yizzuide.milkomeda.crust.GrantedAuthorityImpl;
import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.CacheHelper;
import com.github.yizzuide.milkomeda.light.LightCacheable;
import com.github.yizzuide.milkomeda.light.Spot;
import com.github.yizzuide.milkomeda.universe.context.AopContextHolder;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.util.JwtUtil;
import io.jsonwebtoken.Claims;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class Crust {
    static final String CATCH_NAME = "lightCacheCrust";
    private static final String CATCH_KEY_PREFIX = "crust:user:";
    private static ThreadLocal<CrustTokenMetaData> tokenMetaDataThreadLocal = new ThreadLocal();
    private static final String UID = "uid";
    private static final String USERNAME = "sub";
    private static final String CREATED = "iat";
    private static final String AUTHORITIES = "authorities";
    private static final String ROLE_IDS = "roles";
    @Autowired
    private CrustProperties props;
    @Resource
    Cache lightCacheCrust;

    @NonNull
    public <T> CrustUserInfo<T> login(@NonNull String username, @NonNull String password, @NonNull Class<T> entityClazz) {
        CrustAuthenticationToken authenticationToken = new CrustAuthenticationToken(username, password);
        authenticationToken.setDetails(new WebAuthenticationDetailsSource().buildDetails(WebContext.getRequest()));
        AuthenticationManager authenticationManager = (AuthenticationManager)ApplicationContextHolder.get().getBean(AuthenticationManager.class);
        Authentication authentication = authenticationManager.authenticate((Authentication)authenticationToken);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        if (this.props.isStateless()) {
            return this.generateToken(authentication, entityClazz);
        }
        return this.getLoginUserInfo(authentication, entityClazz);
    }

    public String refreshToken() {
        String refreshedToken;
        if (!this.props.isStateless()) {
            return null;
        }
        try {
            Claims claims = JwtUtil.parseToken(this.getToken(), this.getUnSignKey());
            claims.put((Object)CREATED, (Object)new Date());
            refreshedToken = JwtUtil.generateToken((Map<String, Object>)claims, this.getSignKey(), Math.toIntExact(this.props.getExpire().toMinutes()), this.props.isUseRsa());
        }
        catch (Exception e) {
            refreshedToken = null;
        }
        return refreshedToken;
    }

    public String getUsername() {
        Authentication authentication = this.getAuthentication();
        if (authentication != null) {
            return authentication.getName();
        }
        return null;
    }

    @NonNull
    public <T> CrustUserInfo<T> getUserInfo(@NonNull Class<T> entityClazz) {
        Authentication authentication = this.getAuthentication();
        if (authentication == null) {
            throw new RuntimeException("authentication is null");
        }
        if (this.getProps().isEnableCache() && !this.props.isStateless()) {
            Spot spot = CacheHelper.get(this.lightCacheCrust);
            if (spot != null && spot.getData() != null) {
                return (CrustUserInfo)spot.getData();
            }
            CrustUserInfo<T> userInfo = this.getLoginUserInfo(authentication, entityClazz);
            Spot<String, CrustUserInfo<T>> sessionSpot = new Spot<String, CrustUserInfo<T>>();
            sessionSpot.setView(userInfo.getUid());
            sessionSpot.setData(userInfo);
            CacheHelper.set(this.lightCacheCrust, sessionSpot);
            return userInfo;
        }
        Crust crustProxy = (Crust)AopContextHolder.self(this.getClass());
        return crustProxy.getTokenUserInfo(authentication, entityClazz);
    }

    @NonNull
    public SecurityContext getContext() {
        return SecurityContextHolder.getContext();
    }

    public void invalidate() {
        if (this.getProps().isEnableCache() && this.getProps().isStateless()) {
            CacheHelper.erase(this.lightCacheCrust, (Serializable)((Object)this.getUserInfo(Serializable.class).getUid()), id -> CATCH_KEY_PREFIX + id);
        }
        SecurityContextHolder.clearContext();
    }

    long getTokenIssue() {
        return tokenMetaDataThreadLocal.get().getIssuedAt();
    }

    long getTokenExpire() {
        return tokenMetaDataThreadLocal.get().getExpire();
    }

    void checkAuthentication() {
        Authentication authentication = this.getAuthenticationFromToken();
        SecurityContextHolder.getContext().setAuthentication(authentication);
    }

    Authentication getAuthenticationFromToken() {
        Object authentication = null;
        String token = this.getToken();
        if (token != null) {
            if (this.getAuthentication() == null) {
                String unSignKey = this.getUnSignKey();
                Claims claims = JwtUtil.parseToken(token, unSignKey);
                if (claims == null) {
                    return null;
                }
                String username = claims.getSubject();
                if (username == null) {
                    return null;
                }
                if (JwtUtil.isTokenExpired(token, unSignKey).booleanValue()) {
                    return null;
                }
                Object authorsObj = claims.get((Object)AUTHORITIES);
                List authorities = null;
                if (authorsObj != null) {
                    authorities = Arrays.stream(((String)authorsObj).split(",")).map(GrantedAuthorityImpl::new).collect(Collectors.toList());
                }
                Object RoleIdsObj = claims.get((Object)ROLE_IDS);
                List<Long> roleIds = null;
                if (RoleIdsObj != null) {
                    roleIds = Arrays.stream(((String)RoleIdsObj).split(",")).map(Long::parseLong).collect(Collectors.toList());
                }
                long issuedAt = (Long)claims.get((Object)CREATED);
                String uid = (String)claims.get((Object)UID);
                long expire = claims.getExpiration().getTime();
                CrustTokenMetaData tokenMetaData = new CrustTokenMetaData(username, uid, issuedAt, expire);
                tokenMetaDataThreadLocal.set(tokenMetaData);
                CrustUserDetails userDetails = new CrustUserDetails(uid, username, authorities, roleIds);
                authentication = new CrustAuthenticationToken(userDetails, null, authorities, token);
            } else if (this.validateToken(token, this.getUsername()).booleanValue()) {
                authentication = this.getAuthentication();
            }
        }
        return authentication;
    }

    void clearTokenMetaData() {
        tokenMetaDataThreadLocal.remove();
    }

    @NonNull
    private Boolean validateToken(@NonNull String token, @NonNull String username) {
        String userName = tokenMetaDataThreadLocal.get().getUsername();
        if (StringUtils.isEmpty((Object)userName)) {
            return false;
        }
        return userName.equals(username) && JwtUtil.isTokenExpired(token, this.getUnSignKey()) == false;
    }

    @NonNull
    private <T> CrustUserInfo<T> generateToken(@NonNull Authentication authentication, @NonNull Class<T> entityClazz) {
        List<Long> roleIds;
        Object principal;
        HashMap<String, Object> claims = new HashMap<String, Object>(6);
        CrustUserInfo<T> userInfo = this.getLoginUserInfo(authentication, entityClazz);
        claims.put(UID, userInfo.getUid());
        claims.put(USERNAME, userInfo.getUsername());
        claims.put(CREATED, new Date());
        if (!CollectionUtils.isEmpty((Collection)authentication.getAuthorities())) {
            claims.put(AUTHORITIES, StringUtils.arrayToCommaDelimitedString((Object[])authentication.getAuthorities().stream().map(GrantedAuthority::getAuthority).toArray()));
        }
        if ((principal = authentication.getPrincipal()) instanceof CrustUserDetails && !CollectionUtils.isEmpty(roleIds = ((CrustUserDetails)principal).getRoleIds())) {
            claims.put(ROLE_IDS, StringUtils.arrayToCommaDelimitedString((Object[])roleIds.toArray()));
        }
        String token = JwtUtil.generateToken(claims, this.getSignKey(), Math.toIntExact(this.props.getExpire().toMinutes()), this.props.isUseRsa());
        userInfo.setToken(token);
        return userInfo;
    }

    @LightCacheable(value="lightCacheCrust", keyPrefix="crust:user:", key="T(org.springframework.util.DigestUtils).md5DigestAsHex(#authentication?.token.bytes)", condition="#authentication!=null&&#target.props.enableCache")
    public <T> CrustUserInfo<T> getTokenUserInfo(Authentication authentication, @NonNull Class<T> clazz) {
        CrustUserInfo<T> userInfo = null;
        if (authentication != null && authentication instanceof CrustAuthenticationToken) {
            CrustAuthenticationToken authenticationToken = (CrustAuthenticationToken)authentication;
            String token = authenticationToken.getToken();
            Object principal = authentication.getPrincipal();
            if (principal instanceof CrustUserDetails) {
                CrustUserDetails userDetails = (CrustUserDetails)principal;
                String uid = userDetails.getUid();
                List<Long> roleIds = userDetails.getRoleIds();
                CrustUserDetailsService detailsService = (CrustUserDetailsService)ApplicationContextHolder.get().getBean(CrustUserDetailsService.class);
                Serializable entity = detailsService.findEntityById(uid);
                return new CrustUserInfo<Serializable>(uid, authenticationToken.getName(), token, roleIds, entity);
            }
        }
        return userInfo;
    }

    private <T> CrustUserInfo<T> getLoginUserInfo(Authentication authentication, @NonNull Class<T> clazz) {
        if (authentication == null) {
            throw new AuthenticationServiceException("Authentication is must be not null");
        }
        Object principal = authentication.getPrincipal();
        if (!(principal instanceof CrustUserDetails)) {
            throw new AuthenticationServiceException("Authentication principal must be subtype of CrustUserDetails");
        }
        CrustUserDetails userDetails = (CrustUserDetails)principal;
        return new CrustUserInfo<Serializable>(userDetails.getUid(), userDetails.getUsername(), this.getToken(), userDetails.getRoleIds(), userDetails.getEntity());
    }

    private Authentication getAuthentication() {
        if (SecurityContextHolder.getContext() == null) {
            return null;
        }
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Nullable
    public String getToken() {
        if (!this.props.isStateless()) {
            return null;
        }
        String token = WebContext.getRequest().getHeader(this.props.getTokenName());
        if (StringUtils.isEmpty((Object)token)) {
            return null;
        }
        String tokenHead = "Bearer ";
        if (token.contains(tokenHead)) {
            token = token.substring(tokenHead.length());
        }
        return token;
    }

    private String getSignKey() {
        if (this.props.isUseRsa()) {
            return this.props.getPriKey();
        }
        return this.props.getSecureKey();
    }

    private String getUnSignKey() {
        if (this.props.isUseRsa()) {
            return this.props.getPubKey();
        }
        return this.props.getSecureKey();
    }

    public CrustProperties getProps() {
        return this.props;
    }
}

