/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustAuthenticationFilter;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.crust.RefreshSuccessHandler;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import java.util.function.Supplier;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class CrustAuthenticationConfigurer<T extends CrustAuthenticationConfigurer<T, B>, B extends HttpSecurityBuilder<B>>
extends AbstractHttpConfigurer<T, B> {
    private CrustAuthenticationFilter authFilter = new CrustAuthenticationFilter();
    private Supplier<AuthenticationFailureHandler> authFailureHandler;

    public CrustAuthenticationConfigurer() {
        this(null);
    }

    public CrustAuthenticationConfigurer(Supplier<AuthenticationFailureHandler> authFailureHandler) {
        this.authFailureHandler = authFailureHandler;
    }

    public void configure(B http) {
        this.authFilter.setAuthenticationFailureHandler(this.authFailureHandler.get());
        CrustProperties crustProperties = (CrustProperties)ApplicationContextHolder.get().getBean(CrustProperties.class);
        if (crustProperties.isEnableAutoRefreshToken()) {
            this.authFilter.setAuthenticationSuccessHandler(new RefreshSuccessHandler(crustProperties.getRefreshTokenName()));
        }
        CrustAuthenticationFilter filter = (CrustAuthenticationFilter)((Object)this.postProcess((Object)this.authFilter));
        http.addFilterBefore((Filter)filter, UsernamePasswordAuthenticationFilter.class);
    }

    CrustAuthenticationConfigurer<T, B> permissiveRequestUrls(String ... urls) {
        this.authFilter.setPermissiveUrl(urls);
        return this;
    }
}

