/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.Crust;
import com.github.yizzuide.milkomeda.crust.CrustContext;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import io.jsonwebtoken.ClaimJwtException;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class CrustAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(CrustAuthenticationFilter.class);
    private RequestMatcher requiresAuthenticationRequestMatcher;
    private List<RequestMatcher> permissiveRequestMatchers;
    private AuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    private AuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();

    CrustAuthenticationFilter() {
        String tokenName = ((CrustProperties)ApplicationContextHolder.get().getBean(CrustProperties.class)).getTokenName();
        this.requiresAuthenticationRequestMatcher = new RequestHeaderRequestMatcher(tokenName);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.requiresAuthentication(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Authentication authResult = null;
        Throwable failed = null;
        Crust crust = CrustContext.get();
        String token = crust.getToken();
        try {
            if (StringUtils.isNotBlank((CharSequence)token)) {
                authResult = crust.getAuthenticationFromToken();
            } else {
                failed = new InsufficientAuthenticationException("Require Token is not set");
            }
        }
        catch (ClaimJwtException e) {
            log.error("JWT format error: {}", (Object)e.getMessage(), (Object)e);
            failed = new InsufficientAuthenticationException("JWT format error", failed);
        }
        catch (InternalAuthenticationServiceException e) {
            log.error("An internal error occurred while trying to authenticate the user.", failed);
            failed = e;
        }
        catch (AuthenticationException e) {
            failed = e;
        }
        if (authResult != null) {
            this.successfulAuthentication(request, response, chain, authResult);
        } else if (!this.permissiveRequest(request)) {
            this.unsuccessfulAuthentication(request, response, (AuthenticationException)failed);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
        crust.clearTokenMetaData();
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response, failed);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.successHandler.onAuthenticationSuccess(request, response, authResult);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return this.requiresAuthenticationRequestMatcher.matches(request);
    }

    protected boolean permissiveRequest(HttpServletRequest request) {
        if (this.permissiveRequestMatchers == null) {
            return false;
        }
        for (RequestMatcher permissiveMatcher : this.permissiveRequestMatchers) {
            if (!permissiveMatcher.matches(request)) continue;
            return true;
        }
        return false;
    }

    public void setPermissiveUrl(String ... urls) {
        if (this.permissiveRequestMatchers == null) {
            this.permissiveRequestMatchers = new ArrayList<RequestMatcher>();
        }
        for (String url : urls) {
            this.permissiveRequestMatchers.add((RequestMatcher)new AntPathRequestMatcher(url));
        }
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler successHandler) {
        Assert.notNull((Object)successHandler, (String)"successHandler cannot be null");
        this.successHandler = successHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler failureHandler) {
        Assert.notNull((Object)failureHandler, (String)"failureHandler cannot be null");
        this.failureHandler = failureHandler;
    }
}

