/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.crust.CrustUserDetails;
import com.github.yizzuide.milkomeda.crust.PasswordEncoder;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

public class CrustAuthenticationProvider
extends DaoAuthenticationProvider {
    private CrustProperties props;

    public CrustAuthenticationProvider(CrustProperties props, BCryptPasswordEncoder passwordEncoder) {
        this.props = props;
        if (props.isUseBcrypt() && passwordEncoder != null) {
            this.setPasswordEncoder((org.springframework.security.crypto.password.PasswordEncoder)passwordEncoder);
        }
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        boolean isMatched;
        if (this.props.isUseBcrypt()) {
            super.additionalAuthenticationChecks(userDetails, authentication);
            return;
        }
        if (authentication.getCredentials() == null) {
            this.logger.debug((Object)"Authentication failed: no credentials provided");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
        String presentedPassword = authentication.getCredentials().toString();
        if (this.getPasswordEncoder() != null) {
            isMatched = this.getPasswordEncoder().matches((CharSequence)presentedPassword, userDetails.getPassword());
        } else {
            String salt = ((CrustUserDetails)userDetails).getSalt();
            isMatched = new PasswordEncoder(salt).matches(presentedPassword, userDetails.getPassword());
        }
        if (!isMatched) {
            this.logger.debug((Object)"Authentication failed: password does not match stored value");
            throw new BadCredentialsException(this.messages.getMessage("AbstractUserDetailsAuthenticationProvider.badCredentials", "Bad credentials"));
        }
    }
}

