/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.Crust;
import com.github.yizzuide.milkomeda.crust.CrustContext;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.light.Cache;
import com.github.yizzuide.milkomeda.light.LightCache;
import com.github.yizzuide.milkomeda.light.LightCacheAspect;
import com.github.yizzuide.milkomeda.light.LightCacheClearFilter;
import com.github.yizzuide.milkomeda.light.LightProperties;
import java.util.Collections;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

@Configuration
@ConditionalOnClass(value={AuthenticationManager.class})
@EnableConfigurationProperties(value={CrustProperties.class, LightProperties.class})
public class CrustConfig {
    @Autowired
    private LightProperties lightProps;
    @Autowired
    private CrustProperties crustProps;

    @Bean
    public Crust crust() {
        return new Crust();
    }

    @Autowired
    public void configCrustContext(Crust crust) {
        CrustContext.set(crust);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="milkomeda.crust", name={"use-bcrypt"}, havingValue="true", matchIfMissing=true)
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="milkomeda.crust", name={"enable-cache"}, havingValue="true", matchIfMissing=true)
    public LightCacheAspect lightCacheAspect() {
        return new LightCacheAspect();
    }

    @Bean(value={"lightCacheCrust"})
    @ConditionalOnProperty(prefix="milkomeda.crust", name={"enable-cache"}, havingValue="true", matchIfMissing=true)
    public Cache lightCache() {
        LightCache lightCache = new LightCache();
        lightCache.setL1MaxCount(this.lightProps.getL1MaxCount());
        lightCache.setL1DiscardPercent(Float.valueOf(this.lightProps.getL1DiscardPercent()));
        lightCache.setL1Expire(this.lightProps.getL1Expire().getSeconds());
        lightCache.setStrategy(this.lightProps.getStrategy());
        lightCache.setStrategyClass(this.lightProps.getStrategyClass());
        lightCache.setOnlyCacheL1(!this.crustProps.isEnableCacheL2());
        lightCache.setL2Expire(this.lightProps.getL2Expire().getSeconds());
        lightCache.setOnlyCacheL2(false);
        return lightCache;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="milkomeda.crust", name={"enable-cache"}, havingValue="true", matchIfMissing=true)
    public FilterRegistrationBean<LightCacheClearFilter> lightCacheClearFilter() {
        FilterRegistrationBean lightCacheClearFilter = new FilterRegistrationBean();
        lightCacheClearFilter.setFilter((Filter)new LightCacheClearFilter());
        lightCacheClearFilter.setName("lightCacheClearFilter");
        lightCacheClearFilter.setUrlPatterns(Collections.singleton("/*"));
        return lightCacheClearFilter;
    }
}

