/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustAuthenticationConfigurer;
import com.github.yizzuide.milkomeda.crust.CrustAuthenticationProvider;
import com.github.yizzuide.milkomeda.crust.CrustContext;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.HttpStatusReturningLogoutSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

public class CrustConfigurerAdapter
extends WebSecurityConfigurerAdapter {
    @Autowired
    private CrustProperties props;
    @Autowired(required=false)
    private BCryptPasswordEncoder passwordEncoder;

    public void configure(AuthenticationManagerBuilder auth) {
        CrustAuthenticationProvider authenticationProvider = new CrustAuthenticationProvider(this.props, this.passwordEncoder);
        this.configureProvider(authenticationProvider);
        auth.authenticationProvider((AuthenticationProvider)authenticationProvider);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().disable()).sessionManagement().sessionCreationPolicy(this.props.isStateless() ? SessionCreationPolicy.STATELESS : SessionCreationPolicy.IF_REQUIRED).and()).formLogin().disable()).cors().and();
        this.presetConfigure(http);
        if (this.props.isStateless()) {
            ((HttpSecurity)((CrustAuthenticationConfigurer)http.apply(new CrustAuthenticationConfigurer(this.authFailureHandler()))).permissiveRequestUrls(this.props.getLogoutUrl()).and()).logout().logoutUrl(this.props.getLogoutUrl()).addLogoutHandler((req, res, auth) -> CrustContext.invalidate()).logoutSuccessHandler((LogoutSuccessHandler)new HttpStatusReturningLogoutSuccessHandler());
        } else {
            ((HttpSecurity)((HttpSecurity)http.httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)new LoginUrlAuthenticationEntryPoint(this.props.getLoginUrl())).and()).sessionManagement().sessionAuthenticationErrorUrl(this.props.getLoginUrl()).sessionAuthenticationFailureHandler(this.authFailureHandler().get()).and()).logout().logoutUrl(this.props.getLogoutUrl()).logoutSuccessUrl(this.props.getLoginUrl()).invalidateHttpSession(true);
        }
    }

    protected void configureProvider(@NonNull DaoAuthenticationProvider provider) {
    }

    @NonNull
    protected Supplier<AuthenticationFailureHandler> authFailureHandler() {
        return () -> (request, response, exception) -> response.setStatus(HttpStatus.UNAUTHORIZED.value());
    }

    protected void presetConfigure(HttpSecurity http) throws Exception {
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry = ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().antMatchers(HttpMethod.OPTIONS, new String[]{"/**"})).permitAll().antMatchers(new String[]{this.props.getLoginUrl()})).permitAll().antMatchers(new String[]{"/webjars/**"})).permitAll().antMatchers(new String[]{"/druid/**"})).permitAll().antMatchers(new String[]{"/swagger-ui.html"})).permitAll().antMatchers(new String[]{"/swagger-resources"})).permitAll().antMatchers(new String[]{"/webjars/springfox-swagger-ui/**"})).permitAll().antMatchers(new String[]{"/actuator/**"})).permitAll();
        this.additionalConfigure(urlRegistry, http);
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
    }

    protected void additionalConfigure(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry urlRegistry, HttpSecurity http) throws Exception {
    }

    @Bean(name={"org.springframework.security.authenticationManager"})
    public AuthenticationManager authenticationManager() throws Exception {
        return super.authenticationManager();
    }

    @Bean
    protected CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Collections.singletonList("*"));
        configuration.setAllowedMethods(Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTION"));
        configuration.setAllowedHeaders(Collections.singletonList("*"));
        configuration.addExposedHeader(this.props.getRefreshTokenName());
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }
}

