/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="milkomeda.crust")
public class CrustProperties {
    private boolean stateless = true;
    private boolean enableCache = true;
    private boolean enableCacheL2 = true;
    private boolean useRsa = false;
    private String secureKey;
    private String pubKey;
    private String priKey;
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration expire = Duration.ofMinutes(30L);
    private String tokenName = "token";
    private boolean useBcrypt = true;
    private boolean enableAutoRefreshToken = true;
    @DurationUnit(value=ChronoUnit.MINUTES)
    private Duration refreshTokenInterval = Duration.ofMinutes(5L);
    private String refreshTokenName = "Authorization";
    private String loginUrl = "/login";
    private String logoutUrl = "/logout";

    public boolean isStateless() {
        return this.stateless;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public boolean isEnableCacheL2() {
        return this.enableCacheL2;
    }

    public boolean isUseRsa() {
        return this.useRsa;
    }

    public String getSecureKey() {
        return this.secureKey;
    }

    public String getPubKey() {
        return this.pubKey;
    }

    public String getPriKey() {
        return this.priKey;
    }

    public Duration getExpire() {
        return this.expire;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public boolean isUseBcrypt() {
        return this.useBcrypt;
    }

    public boolean isEnableAutoRefreshToken() {
        return this.enableAutoRefreshToken;
    }

    public Duration getRefreshTokenInterval() {
        return this.refreshTokenInterval;
    }

    public String getRefreshTokenName() {
        return this.refreshTokenName;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getLogoutUrl() {
        return this.logoutUrl;
    }

    public void setStateless(boolean stateless) {
        this.stateless = stateless;
    }

    public void setEnableCache(boolean enableCache) {
        this.enableCache = enableCache;
    }

    public void setEnableCacheL2(boolean enableCacheL2) {
        this.enableCacheL2 = enableCacheL2;
    }

    public void setUseRsa(boolean useRsa) {
        this.useRsa = useRsa;
    }

    public void setSecureKey(String secureKey) {
        this.secureKey = secureKey;
    }

    public void setPubKey(String pubKey) {
        this.pubKey = pubKey;
    }

    public void setPriKey(String priKey) {
        this.priKey = priKey;
    }

    public void setExpire(Duration expire) {
        this.expire = expire;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public void setUseBcrypt(boolean useBcrypt) {
        this.useBcrypt = useBcrypt;
    }

    public void setEnableAutoRefreshToken(boolean enableAutoRefreshToken) {
        this.enableAutoRefreshToken = enableAutoRefreshToken;
    }

    public void setRefreshTokenInterval(Duration refreshTokenInterval) {
        this.refreshTokenInterval = refreshTokenInterval;
    }

    public void setRefreshTokenName(String refreshTokenName) {
        this.refreshTokenName = refreshTokenName;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setLogoutUrl(String logoutUrl) {
        this.logoutUrl = logoutUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CrustProperties)) {
            return false;
        }
        CrustProperties other = (CrustProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isStateless() != other.isStateless()) {
            return false;
        }
        if (this.isEnableCache() != other.isEnableCache()) {
            return false;
        }
        if (this.isEnableCacheL2() != other.isEnableCacheL2()) {
            return false;
        }
        if (this.isUseRsa() != other.isUseRsa()) {
            return false;
        }
        String this$secureKey = this.getSecureKey();
        String other$secureKey = other.getSecureKey();
        if (this$secureKey == null ? other$secureKey != null : !this$secureKey.equals(other$secureKey)) {
            return false;
        }
        String this$pubKey = this.getPubKey();
        String other$pubKey = other.getPubKey();
        if (this$pubKey == null ? other$pubKey != null : !this$pubKey.equals(other$pubKey)) {
            return false;
        }
        String this$priKey = this.getPriKey();
        String other$priKey = other.getPriKey();
        if (this$priKey == null ? other$priKey != null : !this$priKey.equals(other$priKey)) {
            return false;
        }
        Duration this$expire = this.getExpire();
        Duration other$expire = other.getExpire();
        if (this$expire == null ? other$expire != null : !((Object)this$expire).equals(other$expire)) {
            return false;
        }
        String this$tokenName = this.getTokenName();
        String other$tokenName = other.getTokenName();
        if (this$tokenName == null ? other$tokenName != null : !this$tokenName.equals(other$tokenName)) {
            return false;
        }
        if (this.isUseBcrypt() != other.isUseBcrypt()) {
            return false;
        }
        if (this.isEnableAutoRefreshToken() != other.isEnableAutoRefreshToken()) {
            return false;
        }
        Duration this$refreshTokenInterval = this.getRefreshTokenInterval();
        Duration other$refreshTokenInterval = other.getRefreshTokenInterval();
        if (this$refreshTokenInterval == null ? other$refreshTokenInterval != null : !((Object)this$refreshTokenInterval).equals(other$refreshTokenInterval)) {
            return false;
        }
        String this$refreshTokenName = this.getRefreshTokenName();
        String other$refreshTokenName = other.getRefreshTokenName();
        if (this$refreshTokenName == null ? other$refreshTokenName != null : !this$refreshTokenName.equals(other$refreshTokenName)) {
            return false;
        }
        String this$loginUrl = this.getLoginUrl();
        String other$loginUrl = other.getLoginUrl();
        if (this$loginUrl == null ? other$loginUrl != null : !this$loginUrl.equals(other$loginUrl)) {
            return false;
        }
        String this$logoutUrl = this.getLogoutUrl();
        String other$logoutUrl = other.getLogoutUrl();
        return !(this$logoutUrl == null ? other$logoutUrl != null : !this$logoutUrl.equals(other$logoutUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CrustProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isStateless() ? 79 : 97);
        result = result * 59 + (this.isEnableCache() ? 79 : 97);
        result = result * 59 + (this.isEnableCacheL2() ? 79 : 97);
        result = result * 59 + (this.isUseRsa() ? 79 : 97);
        String $secureKey = this.getSecureKey();
        result = result * 59 + ($secureKey == null ? 43 : $secureKey.hashCode());
        String $pubKey = this.getPubKey();
        result = result * 59 + ($pubKey == null ? 43 : $pubKey.hashCode());
        String $priKey = this.getPriKey();
        result = result * 59 + ($priKey == null ? 43 : $priKey.hashCode());
        Duration $expire = this.getExpire();
        result = result * 59 + ($expire == null ? 43 : ((Object)$expire).hashCode());
        String $tokenName = this.getTokenName();
        result = result * 59 + ($tokenName == null ? 43 : $tokenName.hashCode());
        result = result * 59 + (this.isUseBcrypt() ? 79 : 97);
        result = result * 59 + (this.isEnableAutoRefreshToken() ? 79 : 97);
        Duration $refreshTokenInterval = this.getRefreshTokenInterval();
        result = result * 59 + ($refreshTokenInterval == null ? 43 : ((Object)$refreshTokenInterval).hashCode());
        String $refreshTokenName = this.getRefreshTokenName();
        result = result * 59 + ($refreshTokenName == null ? 43 : $refreshTokenName.hashCode());
        String $loginUrl = this.getLoginUrl();
        result = result * 59 + ($loginUrl == null ? 43 : $loginUrl.hashCode());
        String $logoutUrl = this.getLogoutUrl();
        result = result * 59 + ($logoutUrl == null ? 43 : $logoutUrl.hashCode());
        return result;
    }

    public String toString() {
        return "CrustProperties(stateless=" + this.isStateless() + ", enableCache=" + this.isEnableCache() + ", enableCacheL2=" + this.isEnableCacheL2() + ", useRsa=" + this.isUseRsa() + ", secureKey=" + this.getSecureKey() + ", pubKey=" + this.getPubKey() + ", priKey=" + this.getPriKey() + ", expire=" + this.getExpire() + ", tokenName=" + this.getTokenName() + ", useBcrypt=" + this.isUseBcrypt() + ", enableAutoRefreshToken=" + this.isEnableAutoRefreshToken() + ", refreshTokenInterval=" + this.getRefreshTokenInterval() + ", refreshTokenName=" + this.getRefreshTokenName() + ", loginUrl=" + this.getLoginUrl() + ", logoutUrl=" + this.getLogoutUrl() + ")";
    }
}

