/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustEntity;
import com.github.yizzuide.milkomeda.crust.CrustPerm;
import com.github.yizzuide.milkomeda.crust.CrustUserDetails;
import com.github.yizzuide.milkomeda.crust.GrantedAuthorityImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.util.CollectionUtils;

public abstract class CrustUserDetailsService
implements UserDetailsService {
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        CrustEntity entity = this.findEntityByUsername(username);
        if (entity == null) {
            throw new UsernameNotFoundException("Not Found: " + username);
        }
        CrustPerm crustPerm = this.findPermissionsById(entity.getUID(), username);
        List grantedAuthorities = null;
        ArrayList<Long> roleIds = null;
        if (crustPerm != null) {
            if (!CollectionUtils.isEmpty(crustPerm.getRoleIds())) {
                roleIds = new ArrayList<Long>(crustPerm.getRoleIds());
            }
            if (!CollectionUtils.isEmpty(crustPerm.getPermNames())) {
                grantedAuthorities = crustPerm.getPermNames().stream().map(GrantedAuthorityImpl::new).collect(Collectors.toList());
            }
        }
        return new CrustUserDetails(entity.getUID(), entity.getUsername(), entity.getPassword(), entity.getSalt(), grantedAuthorities, roleIds, entity);
    }

    @Nullable
    protected Serializable findEntityById(String uid) {
        return null;
    }

    @Nullable
    protected abstract CrustEntity findEntityByUsername(String var1);

    @Nullable
    protected abstract CrustPerm findPermissionsById(String var1, String var2);
}

