/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.crust;

import com.github.yizzuide.milkomeda.crust.CrustContext;
import com.github.yizzuide.milkomeda.crust.CrustProperties;
import com.github.yizzuide.milkomeda.universe.context.ApplicationContextHolder;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;

class RefreshSuccessHandler
implements AuthenticationSuccessHandler {
    private final long tokenRefreshInterval = ((CrustProperties)ApplicationContextHolder.get().getBean(CrustProperties.class)).getRefreshTokenInterval().toMinutes();
    private final String refreshTokenName;

    RefreshSuccessHandler(String refreshTokenName) {
        this.refreshTokenName = refreshTokenName;
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        boolean shouldRefresh = this.shouldTokenRefresh(CrustContext.get().getTokenExpire());
        if (shouldRefresh) {
            response.setHeader(this.refreshTokenName, CrustContext.get().refreshToken());
        }
    }

    private boolean shouldTokenRefresh(long expire) {
        LocalDateTime expireTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(expire), ZoneId.systemDefault());
        return LocalDateTime.now().isAfter(expireTime.minusMinutes(this.tokenRefreshInterval));
    }
}

