/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.yizzuide.milkomeda.echo.EchoException;
import com.github.yizzuide.milkomeda.echo.EchoResponseData;
import com.github.yizzuide.milkomeda.universe.config.MilkomedaProperties;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public abstract class AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(AbstractRequest.class);
    @Resource(name="echoRestTemplate")
    private RestTemplate restTemplate;
    @Autowired
    private MilkomedaProperties milkomedaProperties;

    public static String getPostData(InputStream inputStream) {
        StringBuilder data;
        try {
            String str;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            data = new StringBuilder();
            while ((str = reader.readLine()) != null) {
                data.append(str);
            }
        }
        catch (IOException e) {
            log.error("abstractRequest:- get request body error with message: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
        return data.toString();
    }

    public EchoResponseData<Map<String, Object>> sendPostForResult(String url, Map<String, Object> map) throws EchoException {
        return this.sendPostForResult(url, map, new TypeReference<Map<String, Object>>(){});
    }

    public <T> EchoResponseData<T> sendPostForResult(String url, Map<String, Object> params, TypeReference<T> specType) throws EchoException {
        return this.sendPostForResult(url, params, specType, false);
    }

    public <T> EchoResponseData<T> sendPostForResult(String url, Map<String, Object> params, TypeReference<T> specType, boolean forceCamel) throws EchoException {
        return this.sendRequest(HttpMethod.POST, url, null, params, specType, forceCamel);
    }

    public EchoResponseData<Map<String, Object>> sendGetForResult(String url) throws EchoException {
        return this.sendRequest(HttpMethod.GET, url, null, null, new TypeReference<Map<String, Object>>(){}, false);
    }

    public EchoResponseData<Map<String, Object>> sendGetForResult(String url, Map<String, Object> params) throws EchoException {
        return this.sendRequest(HttpMethod.GET, url, null, params, new TypeReference<Map<String, Object>>(){}, false);
    }

    public EchoResponseData<Map<String, Object>> sendRequestForResult(HttpMethod method, String url, Map<String, Object> params) throws EchoException {
        return this.sendRequest(method, url, null, params, new TypeReference<Map<String, Object>>(){}, false);
    }

    public <T> EchoResponseData<T> sendRequest(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params, TypeReference<T> specType, boolean forceCamel) throws EchoException {
        boolean hasBody = this.hasBody(method);
        HashMap reqParams = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        boolean showLog = this.milkomedaProperties.isShowLog();
        ResponseEntity<String> request = this.performRequest(method, url, params, headerMap, reqParams, headers, hasBody, showLog, String.class);
        String body = (String)request.getBody();
        boolean useStandardHTTP = this.useStandardHTTP();
        if (null == body && !useStandardHTTP) {
            log.error("abstractRequest:- response with url: {}, params: {}, reqParams:{}, data: null", new Object[]{url, params, reqParams});
            throw new EchoException(7000, "response body is null");
        }
        if (showLog) {
            log.info("abstractRequest:- response with url: {}, params: {}, reqParams:{}, data: {}", new Object[]{url, params, reqParams, body});
        }
        Object responseEntity = null;
        if (null != body) {
            boolean isMap = body.matches("^\\s*\\{.+");
            boolean isList = body.matches("^\\s*\\[.+");
            if (isMap) {
                responseEntity = JSONUtil.parseMap(body, String.class, Object.class);
            } else if (isList) {
                responseEntity = JSONUtil.parseList(body, Map.class);
            } else {
                throw new EchoException(7006, "\u4e0d\u652f\u6301\u7684\u54cd\u5e94\u6570\u636e\uff1a" + body);
            }
            this.checkRawResponse(responseEntity);
            if (forceCamel && null != responseEntity) {
                try {
                    responseEntity = isMap ? JSONUtil.toCamel(responseEntity, new TypeReference<Map>(){}) : JSONUtil.toCamel(responseEntity, new TypeReference<List>(){});
                }
                catch (Exception e) {
                    log.error("abstractRequest:- convert type data  error: {}", (Object)e.getMessage(), (Object)e);
                    throw new EchoException(7006, e.getMessage());
                }
            }
        }
        EchoResponseData<T> responseData = this.createReturnData(responseEntity, specType, useStandardHTTP);
        if (useStandardHTTP) {
            responseData.setCode(String.valueOf(request.getStatusCodeValue()));
        }
        this.checkResponse(responseData);
        return responseData;
    }

    public InputStream sendRequest(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params) {
        boolean showLog;
        HashMap reqParams = new HashMap();
        HttpHeaders headers = new HttpHeaders();
        boolean hasBody = this.hasBody(method);
        ResponseEntity<org.springframework.core.io.Resource> request = this.performRequest(method, url, params, headerMap, reqParams, headers, hasBody, showLog = this.milkomedaProperties.isShowLog(), org.springframework.core.io.Resource.class);
        if (null == request.getBody()) {
            log.error("abstractRequest:- response with url: {}, params: {}, reqParams:{}, data: null", new Object[]{url, params, reqParams});
            throw new EchoException(7000, "response body is null");
        }
        org.springframework.core.io.Resource body = (org.springframework.core.io.Resource)request.getBody();
        if (showLog) {
            log.info("abstractRequest:- response with url: {}, params: {}, reqParams:{}, data: {}", new Object[]{url, params, reqParams, body});
        }
        try {
            return body.getInputStream();
        }
        catch (IOException e) {
            throw new EchoException(7001, e.getMessage());
        }
    }

    private <T> ResponseEntity<T> performRequest(HttpMethod method, String url, Map<String, Object> params, Map<String, String> headerMap, Map reqParams, HttpHeaders headers, boolean hasBody, boolean showLog, Class<T> respType) {
        ResponseEntity request;
        this.appendHeaders(headers);
        if (null != headerMap) {
            for (String key : headerMap.keySet()) {
                headers.add(key, headerMap.get(key));
            }
        }
        if (hasBody && (MediaType.APPLICATION_FORM_URLENCODED.equals((Object)headers.getContentType()) || MediaType.MULTIPART_FORM_DATA.equals((Object)headers.getContentType()))) {
            reqParams = new LinkedMultiValueMap();
        }
        if (null == params) {
            params = new HashMap<String, Object>();
        }
        this.signParam(params, reqParams);
        if (showLog) {
            log.info("abstractRequest:- send request with url: {}, params: {}, reqParams:{}", new Object[]{url, params, reqParams});
        }
        HttpEntity httpEntity = new HttpEntity((Object)(hasBody ? reqParams : null), (MultiValueMap)headers);
        if (hasBody) {
            request = this.restTemplate.exchange(url, method, httpEntity, respType, new Object[0]);
        } else {
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
            for (Object k : reqParams.keySet()) {
                builder.queryParam((String)k, new Object[]{reqParams.get(k)});
            }
            request = reqParams.size() > 0 ? this.restTemplate.exchange(builder.build().encode().toUri(), method, httpEntity, respType) : this.restTemplate.exchange(url, method, httpEntity, respType, new Object[0]);
        }
        return request;
    }

    private boolean hasBody(HttpMethod method) {
        return method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH;
    }

    protected boolean useStandardHTTP() {
        return false;
    }

    protected abstract <T> EchoResponseData<T> createReturnData(Object var1, TypeReference<T> var2, boolean var3) throws EchoException;

    protected void signParam(Map<String, Object> inParams, Map<String, Object> outParams) {
        if (outParams instanceof LinkedMultiValueMap) {
            LinkedMultiValueMap multiValueMap = (LinkedMultiValueMap)outParams;
            for (Map.Entry<String, Object> inEntry : inParams.entrySet()) {
                multiValueMap.add((Object)inEntry.getKey(), inEntry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> inEntry : inParams.entrySet()) {
                outParams.put(inEntry.getKey(), inEntry.getValue());
            }
        }
    }

    protected void appendHeaders(HttpHeaders headers) {
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.add("Accept", "application/json");
    }

    protected void checkRawResponse(Object responseEntity) throws EchoException {
    }

    protected void checkResponse(EchoResponseData responseData) throws EchoException {
    }

    public Map<String, Object> verifyParam(Map<String, Object> inParams) {
        return null;
    }
}

