/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import com.github.yizzuide.milkomeda.echo.EchoConfig;
import com.github.yizzuide.milkomeda.echo.EchoResponseErrorHandler;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@ConditionalOnClass(value={LoadBalanced.class})
@AutoConfigureAfter(value={EchoConfig.class})
public class EchoCloudConfig {
    @LoadBalanced
    @Bean(value={"echoCloudRestTemplate"})
    public RestTemplate simpleRestTemplate(RestTemplateBuilder builder, ClientHttpRequestFactory factory) {
        RestTemplate restTemplate = builder.build();
        restTemplate.setRequestFactory(factory);
        restTemplate.setErrorHandler((ResponseErrorHandler)new EchoResponseErrorHandler());
        return restTemplate;
    }
}

