/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import com.github.yizzuide.milkomeda.echo.EchoProperties;
import com.github.yizzuide.milkomeda.echo.EchoResponseErrorHandler;
import java.util.ArrayList;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={EchoProperties.class})
public class EchoConfig {
    private static final Logger log = LoggerFactory.getLogger(EchoConfig.class);
    @Autowired
    private EchoProperties echoProperties;

    @Bean(value={"echoRestTemplate"})
    public RestTemplate simpleRestTemplate(RestTemplateBuilder builder) {
        RestTemplate restTemplate = builder.build();
        restTemplate.setRequestFactory(this.clientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new EchoResponseErrorHandler());
        return restTemplate;
    }

    @Bean
    public CloseableHttpClient closeableHttpClient() {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.3; rv:36.0) Gecko/20100101 Firefox/36.04"));
        headers.add(new BasicHeader("Accept-Encoding", "gzip, deflate"));
        headers.add(new BasicHeader("Accept-Language", "zh-CN,zh;q=0.8,en-US;q=0.5,en;q=0.3"));
        headers.add(new BasicHeader("Connection", "Keep-Alive"));
        Registry socketFactoryRegistry = null;
        SSLContext sslContext = null;
        try {
            TrustStrategy acceptingTrustStrategy = (chain, authType) -> true;
            sslContext = SSLContexts.custom().loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)acceptingTrustStrategy).build();
            NoopHostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        }
        catch (Exception e) {
            log.error("echo create httpClient SSL error", (Throwable)e);
        }
        PoolingHttpClientConnectionManager poolingConnectionManager = new PoolingHttpClientConnectionManager((Registry)Objects.requireNonNull(socketFactoryRegistry));
        poolingConnectionManager.setMaxTotal(this.echoProperties.getPoolMaxSize());
        poolingConnectionManager.setDefaultMaxPerRoute(this.echoProperties.getDefaultMaxPerRoute());
        return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)poolingConnectionManager).setKeepAliveStrategy((ConnectionKeepAliveStrategy)new DefaultConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                long keepAlive = super.getKeepAliveDuration(response, context);
                if (keepAlive == -1L) {
                    keepAlive = EchoConfig.this.echoProperties.getKeepAlive().toMillis();
                }
                return keepAlive;
            }
        }).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(this.echoProperties.getRetryCount(), this.echoProperties.isEnableRequestSentRetry())).setSSLContext(sslContext).setDefaultHeaders(headers).build();
    }

    @Bean
    public ClientHttpRequestFactory clientHttpRequestFactory() {
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        clientHttpRequestFactory.setHttpClient((HttpClient)this.closeableHttpClient());
        clientHttpRequestFactory.setConnectTimeout((int)this.echoProperties.getConnectTimeout().toMillis());
        clientHttpRequestFactory.setReadTimeout((int)this.echoProperties.getReadTimeout().toMillis());
        clientHttpRequestFactory.setConnectionRequestTimeout((int)this.echoProperties.getConnectionRequestTimeout().toMillis());
        clientHttpRequestFactory.setBufferRequestBody(this.echoProperties.isEnableBufferRequestBody());
        return clientHttpRequestFactory;
    }
}

