/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="milkomeda.echo")
public class EchoProperties {
    private int poolMaxSize = 200;
    private int defaultMaxPerRoute = 50;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration connectTimeout = Duration.ofMillis(5000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration readTimeout = Duration.ofMillis(5000L);
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration connectionRequestTimeout = Duration.ofMillis(200L);
    private boolean enableBufferRequestBody = false;
    @DurationUnit(value=ChronoUnit.MILLIS)
    private Duration keepAlive = Duration.ofMillis(5000L);
    private boolean enableRequestSentRetry = true;
    private int retryCount = 3;

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public int getDefaultMaxPerRoute() {
        return this.defaultMaxPerRoute;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public boolean isEnableBufferRequestBody() {
        return this.enableBufferRequestBody;
    }

    public Duration getKeepAlive() {
        return this.keepAlive;
    }

    public boolean isEnableRequestSentRetry() {
        return this.enableRequestSentRetry;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public void setDefaultMaxPerRoute(int defaultMaxPerRoute) {
        this.defaultMaxPerRoute = defaultMaxPerRoute;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setConnectionRequestTimeout(Duration connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setEnableBufferRequestBody(boolean enableBufferRequestBody) {
        this.enableBufferRequestBody = enableBufferRequestBody;
    }

    public void setKeepAlive(Duration keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setEnableRequestSentRetry(boolean enableRequestSentRetry) {
        this.enableRequestSentRetry = enableRequestSentRetry;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EchoProperties)) {
            return false;
        }
        EchoProperties other = (EchoProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPoolMaxSize() != other.getPoolMaxSize()) {
            return false;
        }
        if (this.getDefaultMaxPerRoute() != other.getDefaultMaxPerRoute()) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Duration this$connectionRequestTimeout = this.getConnectionRequestTimeout();
        Duration other$connectionRequestTimeout = other.getConnectionRequestTimeout();
        if (this$connectionRequestTimeout == null ? other$connectionRequestTimeout != null : !((Object)this$connectionRequestTimeout).equals(other$connectionRequestTimeout)) {
            return false;
        }
        if (this.isEnableBufferRequestBody() != other.isEnableBufferRequestBody()) {
            return false;
        }
        Duration this$keepAlive = this.getKeepAlive();
        Duration other$keepAlive = other.getKeepAlive();
        if (this$keepAlive == null ? other$keepAlive != null : !((Object)this$keepAlive).equals(other$keepAlive)) {
            return false;
        }
        if (this.isEnableRequestSentRetry() != other.isEnableRequestSentRetry()) {
            return false;
        }
        return this.getRetryCount() == other.getRetryCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EchoProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoolMaxSize();
        result = result * 59 + this.getDefaultMaxPerRoute();
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Duration $connectionRequestTimeout = this.getConnectionRequestTimeout();
        result = result * 59 + ($connectionRequestTimeout == null ? 43 : ((Object)$connectionRequestTimeout).hashCode());
        result = result * 59 + (this.isEnableBufferRequestBody() ? 79 : 97);
        Duration $keepAlive = this.getKeepAlive();
        result = result * 59 + ($keepAlive == null ? 43 : ((Object)$keepAlive).hashCode());
        result = result * 59 + (this.isEnableRequestSentRetry() ? 79 : 97);
        result = result * 59 + this.getRetryCount();
        return result;
    }

    public String toString() {
        return "EchoProperties(poolMaxSize=" + this.getPoolMaxSize() + ", defaultMaxPerRoute=" + this.getDefaultMaxPerRoute() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", enableBufferRequestBody=" + this.isEnableBufferRequestBody() + ", keepAlive=" + this.getKeepAlive() + ", enableRequestSentRetry=" + this.isEnableRequestSentRetry() + ", retryCount=" + this.getRetryCount() + ")";
    }
}

