/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.yizzuide.milkomeda.echo.AbstractRequest;
import com.github.yizzuide.milkomeda.echo.EchoException;
import com.github.yizzuide.milkomeda.echo.EchoResponseData;
import com.github.yizzuide.milkomeda.util.JSONUtil;
import com.github.yizzuide.milkomeda.util.TypeUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public abstract class EchoRequest
extends AbstractRequest {
    private static final Logger log = LoggerFactory.getLogger(EchoRequest.class);

    @Override
    protected <T> EchoResponseData<T> createReturnData(Object respData, TypeReference<T> specType, boolean useStandardHTTP) throws EchoException {
        boolean isListType;
        if (null == respData) {
            return this.responseData();
        }
        Class<?> specClazz = TypeUtil.type2Class(specType);
        boolean isMapType = Map.class == specClazz;
        boolean bl = isListType = List.class == specClazz;
        if (useStandardHTTP) {
            if (isListType && respData instanceof Map || isMapType && respData instanceof List) {
                log.error("EchoRequest:- \u54cd\u5e94\u7c7b\u578b\u5339\u914d\u9519\u8bef\uff0c\u5f53\u524d\u54cd\u5e94\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u6307\u5b9a\u7c7b\u578b\u4e3a\uff1a{}", respData.getClass(), specClazz);
                throw new EchoException(3000, "\u54cd\u5e94\u7c7b\u578b\u5339\u914d\u9519\u8bef");
            }
            if (isMapType) {
                EchoResponseData<Map> responseData = this.responseData();
                responseData.setData((Map)respData);
                return responseData;
            }
            if (respData instanceof List && isListType) {
                if (specType.getType() instanceof Class) {
                    EchoResponseData<List> responseData = this.responseData();
                    responseData.setData((List)respData);
                    return responseData;
                }
                ParameterizedType parameterizedType = (ParameterizedType)specType.getType();
                Type paramType = parameterizedType.getActualTypeArguments()[0];
                if (TypeUtil.type2Class(paramType) == Map.class) {
                    EchoResponseData<List> responseData = this.responseData();
                    responseData.setData((List)respData);
                    return responseData;
                }
            }
            EchoResponseData<T> responseData = this.responseData();
            T body = JSONUtil.nativeRead(JSONUtil.serialize(respData), specType);
            responseData.setData(body);
            return responseData;
        }
        EchoResponseData<Object> responseData = this.responseData();
        try {
            if (respData instanceof List) {
                responseData.setCode(String.valueOf(HttpStatus.OK.value()));
                responseData.setData(respData);
                log.warn("EchoRequest:- \u5f53\u524d\u54cd\u5e94\u7684\u6e90\u6570\u636e\u4e0d\u662fJSON Object\uff0c\u800c\u662fJSON Array\uff1a{}", respData);
                return responseData;
            }
            if (respData instanceof Map) {
                BeanUtils.populate(responseData, (Map)((Map)respData));
            }
            if (!isMapType) {
                if (isListType) {
                    if (!(responseData.getData() instanceof List)) {
                        log.error("EchoRequest:- \u54cd\u5e94\u7c7b\u578b\u5339\u914d\u9519\u8bef\uff0c\u5f53\u524d\u54cd\u5e94\u7c7b\u578b\u4e3a\uff1a{}\uff0c\u6307\u5b9a\u7c7b\u578b\u4e3a\uff1a{}", responseData.getData().getClass(), specClazz);
                        throw new EchoException(3000, "\u54cd\u5e94\u7c7b\u578b\u5339\u914d\u9519\u8bef");
                    }
                    if (specType.getType() instanceof Class) {
                        return responseData;
                    }
                    ParameterizedType parameterizedType = (ParameterizedType)specType.getType();
                    Type paramType = parameterizedType.getActualTypeArguments()[0];
                    if (TypeUtil.type2Class(paramType) == Map.class) {
                        return responseData;
                    }
                }
                responseData.setData(JSONUtil.nativeRead(JSONUtil.serialize(responseData.getData()), specType));
            }
        }
        catch (Exception e) {
            log.error("EchoRequest:- create return Data error: {}", (Object)e.getMessage(), (Object)e);
            throw new EchoException(e.getMessage());
        }
        return responseData;
    }

    public EchoResponseData<Map<String, Object>> fetch(HttpMethod method, String url) {
        return this.fetch(method, url, null);
    }

    public EchoResponseData<List<Map<String, Object>>> fetchList(HttpMethod method, String url) {
        return this.fetchList(method, url, null);
    }

    public EchoResponseData<Map<String, Object>> fetch(HttpMethod method, String url, Map<String, Object> params) {
        return this.fetch(method, url, null, params);
    }

    public EchoResponseData<List<Map<String, Object>>> fetchList(HttpMethod method, String url, Map<String, Object> params) {
        return this.fetchList(method, url, null, params);
    }

    public EchoResponseData<Map<String, Object>> fetch(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params) {
        return this.fetch(method, url, headerMap, params, false);
    }

    public EchoResponseData<List<Map<String, Object>>> fetchList(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params) {
        return this.fetchList(method, url, headerMap, params, false);
    }

    public EchoResponseData<Map<String, Object>> fetch(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params, boolean forceCamel) {
        return this.sendRequest(method, url, headerMap, params, new TypeReference<Map<String, Object>>(){}, forceCamel);
    }

    public EchoResponseData<List<Map<String, Object>>> fetchList(HttpMethod method, String url, Map<String, String> headerMap, Map<String, Object> params, boolean forceCamel) {
        return this.sendRequest(method, url, headerMap, params, new TypeReference<List<Map<String, Object>>>(){}, forceCamel);
    }

    protected abstract <T> EchoResponseData<T> responseData();
}

