/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.echo;

import com.github.yizzuide.milkomeda.echo.EchoException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClientException;

public class EchoResponseErrorHandler
implements ResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(EchoResponseErrorHandler.class);
    private ResponseErrorHandler errorHandler = new DefaultResponseErrorHandler();

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            this.errorHandler.handleError(response);
        }
        catch (RestClientException e) {
            if (e instanceof HttpStatusCodeException) {
                HttpStatusCodeException ce = (HttpStatusCodeException)e;
                log.error("echo request with error code: {}, msg:{}, body:{}", new Object[]{ce.getStatusCode().value(), ce.getMessage(), ce.getResponseBodyAsString()});
                throw new EchoException(ce.getStatusCode().value(), ce.getMessage(), ce.getResponseBodyAsString());
            }
            throw new EchoException(7003, e.getMessage());
        }
    }

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return this.errorHandler.hasError(response);
    }
}

