/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.fusion;

import com.github.yizzuide.milkomeda.fusion.Fusion;
import com.github.yizzuide.milkomeda.fusion.FusionAllowedType;
import com.github.yizzuide.milkomeda.fusion.FusionConverter;
import com.github.yizzuide.milkomeda.fusion.FusionGroup;
import com.github.yizzuide.milkomeda.universe.el.ELContext;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.core.annotation.Order;
import org.springframework.util.StringUtils;

@Order(value=99)
@Aspect
public class FusionAspect {
    private FusionConverter<String, Object, Object> converter;

    @Pointcut(value="@within(com.github.yizzuide.milkomeda.fusion.Fusion) && execution(public * *(..))")
    public void classPointCut() {
    }

    @Pointcut(value="@within(com.github.yizzuide.milkomeda.fusion.Fusion) && execution(public * *(..))")
    public void classGroupPointCut() {
    }

    @Pointcut(value="@annotation(com.github.yizzuide.milkomeda.fusion.Fusion) && execution(public * *(..))")
    public void actionPointCut() {
    }

    @Pointcut(value="@annotation(com.github.yizzuide.milkomeda.fusion.FusionGroup) && execution(public * *(..))")
    public void actionGroupPointCut() {
    }

    @Around(value="classPointCut() || actionPointCut() || classGroupPointCut() || actionGroupPointCut()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        Fusion fusion = ReflectUtil.getAnnotation((JoinPoint)joinPoint, Fusion.class);
        if (fusion != null) {
            return this.fusionAroundApply(joinPoint, fusion);
        }
        FusionGroup fusionGroup = ReflectUtil.getAnnotation((JoinPoint)joinPoint, FusionGroup.class);
        return this.fusionGroupAroundApply(joinPoint, fusionGroup);
    }

    private Object fusionGroupAroundApply(ProceedingJoinPoint joinPoint, FusionGroup fusionGroup) throws Throwable {
        List fusions = Stream.of(fusionGroup.value()).sorted((f1, f2) -> {
            if (StringUtils.isEmpty((Object)f1.allowed())) {
                return 1;
            }
            if (StringUtils.isEmpty((Object)f2.allowed())) {
                return -1;
            }
            return 0;
        }).collect(Collectors.toList());
        Fusion resultTagFusion = (Fusion)fusions.get(fusions.size() - 1);
        if (!StringUtils.isEmpty((Object)resultTagFusion.allowed())) {
            resultTagFusion = null;
        }
        StringBuilder allowedExpress = new StringBuilder();
        String fallback = "";
        for (Fusion fusion : fusions) {
            if (fusion == resultTagFusion || StringUtils.isEmpty((Object)fusion.allowed())) continue;
            if (StringUtils.isEmpty((Object)allowedExpress.toString())) {
                allowedExpress.append(fusion.allowed());
                fallback = fusion.fallback();
                continue;
            }
            if (fusion.allowedType() == FusionAllowedType.AND) {
                allowedExpress.append(" && ");
            } else {
                allowedExpress.append(" || ");
            }
            allowedExpress.append(fusion.allowed());
            if (StringUtils.isEmpty((Object)fusion.fallback())) continue;
            fallback = fusion.fallback();
        }
        Object originReturnObj = this.checkAllow(joinPoint, allowedExpress.toString(), fallback);
        if (resultTagFusion == null) {
            return originReturnObj;
        }
        return this.modifyReturn(resultTagFusion, joinPoint, originReturnObj);
    }

    private Object fusionAroundApply(ProceedingJoinPoint joinPoint, Fusion fusion) throws Throwable {
        String allowed = fusion.allowed();
        if (!StringUtils.isEmpty((Object)allowed)) {
            return this.checkAllow(joinPoint, allowed, fusion.fallback());
        }
        return this.modifyReturn(fusion, joinPoint, null);
    }

    private Object checkAllow(ProceedingJoinPoint joinPoint, String allowed, String fallback) throws Throwable {
        if (Boolean.parseBoolean(ELContext.getValue((JoinPoint)joinPoint, allowed))) {
            return joinPoint.proceed();
        }
        if (StringUtils.isEmpty((Object)fallback)) {
            return ReflectUtil.getMethodDefaultReturnVal((JoinPoint)joinPoint);
        }
        return ELContext.getActualValue((JoinPoint)joinPoint, fallback, ReflectUtil.getMethodReturnType((JoinPoint)joinPoint));
    }

    private Object modifyReturn(Fusion resultTagFusion, ProceedingJoinPoint joinPoint, Object originReturnObj) throws Throwable {
        String str;
        Object returnData;
        String condition = resultTagFusion.condition();
        if (!StringUtils.isEmpty((Object)condition) && !Boolean.parseBoolean(ELContext.getValue((JoinPoint)joinPoint, condition))) {
            return originReturnObj == null ? joinPoint.proceed() : originReturnObj;
        }
        String tagName = StringUtils.isEmpty((Object)resultTagFusion.value()) ? resultTagFusion.tag() : resultTagFusion.value();
        Object object = returnData = originReturnObj == null ? joinPoint.proceed() : originReturnObj;
        if (null == this.converter) {
            return returnData;
        }
        if (returnData instanceof String && (str = (String)returnData).startsWith("#E.")) {
            String error = str.substring("#E.".length());
            return this.converter.apply(tagName, null, error);
        }
        return this.converter.apply(tagName, returnData, null);
    }

    public FusionConverter<String, Object, Object> getConverter() {
        return this.converter;
    }

    public void setConverter(FusionConverter<String, Object, Object> converter) {
        this.converter = converter;
    }
}

