/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.halo;

import com.github.yizzuide.milkomeda.halo.HaloContext;
import com.github.yizzuide.milkomeda.halo.HaloMeta;
import com.github.yizzuide.milkomeda.halo.HaloType;
import com.github.yizzuide.milkomeda.pulsar.PulsarHolder;
import com.github.yizzuide.milkomeda.universe.metadata.HandlerMetaData;
import com.github.yizzuide.milkomeda.util.MybatisUtil;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class})})
public class HaloInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(HaloInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        if (CollectionUtils.isEmpty(HaloContext.getTableNameMap())) {
            return invocation.proceed();
        }
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object param = args.length > 1 ? args[1] : null;
        String sql = mappedStatement.getSqlSource().getBoundSql(param).getSql();
        List<String> tableNames = null;
        try {
            tableNames = MybatisUtil.getTableNames(sql);
        }
        catch (Exception e) {
            log.warn("Halo parse sql error: {}, msg: {}", new Object[]{sql, e.getMessage(), e});
        }
        if (CollectionUtils.isEmpty(tableNames)) {
            return invocation.proceed();
        }
        String tableName = tableNames.get(0);
        this.invokeWithTable(tableName, "*", mappedStatement, param, null, HaloType.PRE);
        this.invokeWithTable(tableName, tableName, mappedStatement, param, null, HaloType.PRE);
        Object result = invocation.proceed();
        this.invokeWithTable(tableName, "*", mappedStatement, param, result, HaloType.POST);
        this.invokeWithTable(tableName, tableName, mappedStatement, param, result, HaloType.POST);
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    private void invokeWithTable(String tableName, String matchTableName, MappedStatement mappedStatement, Object param, Object result, HaloType type) {
        if (!HaloContext.getTableNameMap().containsKey(matchTableName)) {
            return;
        }
        HaloContext.getTableNameMap().get(matchTableName).stream().filter(metaData -> metaData.getAttributes().get("type") == type).forEach(handlerMetaData -> {
            if (((Boolean)handlerMetaData.getAttributes().get("async")).booleanValue()) {
                PulsarHolder.getPulsar().post(() -> this.invokeHandler(tableName, (HandlerMetaData)handlerMetaData, mappedStatement, param, result));
            } else {
                this.invokeHandler(tableName, (HandlerMetaData)handlerMetaData, mappedStatement, param, result);
            }
        });
    }

    private void invokeHandler(String tableName, HandlerMetaData handlerMetaData, MappedStatement mappedStatement, Object param, Object result) {
        try {
            SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
            Method method = handlerMetaData.getMethod();
            Object target = handlerMetaData.getTarget();
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length == 1 && parameterTypes[0] == HaloMeta.class) {
                HaloMeta haloMeta = new HaloMeta(sqlCommandType, tableName, param, result);
                method.invoke(target, haloMeta);
            } else if (parameterTypes.length > 1) {
                if (parameterTypes[0] == SqlCommandType.class) {
                    if (result == null) {
                        method.invoke(target, sqlCommandType, param);
                    } else {
                        method.invoke(target, sqlCommandType, param, result);
                    }
                } else if (result == null) {
                    method.invoke(target, param, sqlCommandType);
                } else {
                    method.invoke(target, param, result, sqlCommandType);
                }
            } else {
                method.invoke(target, param);
            }
        }
        catch (Exception e) {
            log.error("Halo invoke handler [{}] error: {}, with stmt id: {}", new Object[]{handlerMetaData.getTarget(), e.getMessage(), mappedStatement.getId(), e});
        }
    }
}

