/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.core;

import com.github.yizzuide.milkomeda.hydrogen.core.HydrogenLoader;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.event.EventListener;
import org.springframework.util.CollectionUtils;

public abstract class AbstractHydrogenLoader<T>
implements HydrogenLoader,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private List<T> loadConfigHandlerList;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        this.refresh();
    }

    @EventListener
    public void configListener(EnvironmentChangeEvent event) {
        if (CollectionUtils.isEmpty((Collection)event.getKeys())) {
            return;
        }
        this.refresh();
    }

    protected void merge(List<T> configHandlerList, Consumer<T> unload, Consumer<T> load) {
        List loadConfigHandlerList = this.getLoadConfigHandlerList();
        if (CollectionUtils.isEmpty(configHandlerList)) {
            if (!CollectionUtils.isEmpty(loadConfigHandlerList)) {
                loadConfigHandlerList.forEach(unload);
                this.setLoadConfigHandlerList(null);
            }
            return;
        }
        if (CollectionUtils.isEmpty(loadConfigHandlerList)) {
            configHandlerList.forEach(load);
            return;
        }
        loadConfigHandlerList.stream().filter(h -> !configHandlerList.contains(h)).collect(Collectors.toList()).forEach(unload);
        configHandlerList.stream().filter(f -> !loadConfigHandlerList.contains(f)).forEach(load);
        this.setLoadConfigHandlerList(configHandlerList);
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public List<T> getLoadConfigHandlerList() {
        return this.loadConfigHandlerList;
    }

    public void setLoadConfigHandlerList(List<T> loadConfigHandlerList) {
        this.loadConfigHandlerList = loadConfigHandlerList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractHydrogenLoader)) {
            return false;
        }
        AbstractHydrogenLoader other = (AbstractHydrogenLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        List<T> this$loadConfigHandlerList = this.getLoadConfigHandlerList();
        List<T> other$loadConfigHandlerList = other.getLoadConfigHandlerList();
        return !(this$loadConfigHandlerList == null ? other$loadConfigHandlerList != null : !((Object)this$loadConfigHandlerList).equals(other$loadConfigHandlerList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractHydrogenLoader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        List<T> $loadConfigHandlerList = this.getLoadConfigHandlerList();
        result = result * 59 + ($loadConfigHandlerList == null ? 43 : ((Object)$loadConfigHandlerList).hashCode());
        return result;
    }

    public String toString() {
        return "AbstractHydrogenLoader(applicationContext=" + this.getApplicationContext() + ", loadConfigHandlerList=" + this.getLoadConfigHandlerList() + ")";
    }
}

