/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.filter;

import com.github.yizzuide.milkomeda.hydrogen.core.AbstractHydrogenLoader;
import com.github.yizzuide.milkomeda.hydrogen.filter.FilterLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;

public abstract class AbstractFilterLoader<T>
extends AbstractHydrogenLoader<T>
implements FilterLoader {
    private ServletContext servletContext;

    @Override
    public List<Map<String, String>> inspect() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        Map filterRegistrations = this.servletContext.getFilterRegistrations();
        for (Map.Entry entry : filterRegistrations.entrySet()) {
            HashMap filterInfoMap = new HashMap();
            filterInfoMap.put("name", entry.getKey());
            FilterRegistration filterRegistration = (FilterRegistration)entry.getValue();
            filterInfoMap.put("class", filterRegistration.getClassName());
            filterInfoMap.put("urlPattern", filterRegistration.getUrlPatternMappings().toString());
            list.add(filterInfoMap);
        }
        return list;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    @Override
    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    @Override
    public String toString() {
        return "AbstractFilterLoader(servletContext=" + this.getServletContext() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractFilterLoader)) {
            return false;
        }
        AbstractFilterLoader other = (AbstractFilterLoader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServletContext this$servletContext = this.getServletContext();
        ServletContext other$servletContext = other.getServletContext();
        return !(this$servletContext == null ? other$servletContext != null : !this$servletContext.equals(other$servletContext));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractFilterLoader;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ServletContext $servletContext = this.getServletContext();
        result = result * 59 + ($servletContext == null ? 43 : $servletContext.hashCode());
        return result;
    }
}

