/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.filter;

import com.github.yizzuide.milkomeda.hydrogen.filter.AbstractFilterLoader;
import com.github.yizzuide.milkomeda.hydrogen.filter.FilterProperties;
import com.github.yizzuide.milkomeda.universe.polyfill.TomcatPolyfill;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;

public class TomcatFilterLoader
extends AbstractFilterLoader<FilterProperties.Filters> {
    private static final Logger log = LoggerFactory.getLogger(TomcatFilterLoader.class);
    private List<FilterProperties.Filters> filtersList;
    @Autowired
    private FilterProperties props;

    @Override
    public boolean load(String name, Class<? extends Filter> clazz, String ... urlPatterns) {
        if (this.getApplicationContext() == null) {
            if (this.filtersList == null) {
                this.filtersList = new ArrayList<FilterProperties.Filters>();
            }
            if (urlPatterns == null) {
                urlPatterns = new String[]{"/*"};
            }
            FilterProperties.Filters filters = new FilterProperties.Filters();
            filters.setName(name);
            filters.setClazz(clazz);
            filters.setUrlPatterns(Arrays.asList(urlPatterns));
            this.filtersList.add(filters);
            return true;
        }
        return TomcatPolyfill.addDynamicFilter(this.getServletContext(), (ConfigurableApplicationContext)this.getApplicationContext(), name, clazz, urlPatterns);
    }

    @Override
    public boolean unload(String name) {
        return TomcatPolyfill.removeDynamicFilter(name, this.getServletContext());
    }

    @Override
    public void refresh() {
        if (this.getServletContext() == null) {
            return;
        }
        if (this.filtersList != null) {
            for (FilterProperties.Filters initFilters : this.filtersList) {
                this.load(initFilters.getName(), initFilters.getClazz(), initFilters.getUrlPatterns().toArray(new String[0]));
            }
            this.filtersList.clear();
            this.filtersList = null;
        }
        List<FilterProperties.Filters> filtersList = this.props.getFilters();
        this.merge(filtersList, f -> this.unload(f.getName()), f -> this.load(f.getName(), f.getClazz(), f.getUrlPatterns().toArray(new String[0])));
    }
}

