/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.i18n;

import com.github.yizzuide.milkomeda.hydrogen.core.HydrogenHolder;
import com.github.yizzuide.milkomeda.hydrogen.i18n.I18nLocaleResolver;
import com.github.yizzuide.milkomeda.hydrogen.i18n.I18nMessages;
import com.github.yizzuide.milkomeda.hydrogen.i18n.I18nProperties;
import com.github.yizzuide.milkomeda.universe.polyfill.SpringMvcPolyfill;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.context.MessageSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableConfigurationProperties(value={I18nProperties.class})
@AutoConfigureAfter(value={MessageSourceAutoConfiguration.class, WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="milkomeda.hydrogen.i18n", name={"enable"}, havingValue="true")
public class I18nConfig {
    private static final Logger log = LoggerFactory.getLogger(I18nConfig.class);
    @Autowired
    private I18nProperties i18nProperties;
    @Autowired
    private MessageSource messageSource;

    @Autowired
    public void config(I18nMessages i18nMessages) {
        HydrogenHolder.setI18nMessages(i18nMessages);
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new I18nLocaleResolver();
    }

    @Bean
    public I18nMessages i18nMessages() {
        return new I18nMessages(this.messageSource);
    }

    @Autowired
    public void configRequestMappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName(this.i18nProperties.getQuery());
        SpringMvcPolyfill.addDynamicInterceptor((HandlerInterceptor)localeChangeInterceptor, -2147483647, Collections.singletonList("/**"), null, (AbstractHandlerMapping)requestMappingHandlerMapping);
    }
}

