/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.i18n;

import com.github.yizzuide.milkomeda.universe.context.WebContext;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class I18nMessages {
    private static final Logger log = LoggerFactory.getLogger(I18nMessages.class);
    private MessageSource messageSource;

    public String get(String key) {
        return this.getWithParam(key, new String[0]);
    }

    public String getWithParam(String key, String ... params) {
        return this.getWithLocaleAndParam(key, LocaleContextHolder.getLocale(), params);
    }

    public String getWithIdentifierAndParam(String key, String localeIdentifier, String ... params) {
        return this.getWithLocaleAndParam(key, StringUtils.parseLocale((String)localeIdentifier), params);
    }

    public String getWithLocaleAndParam(String key, Locale locale, String ... params) {
        try {
            return this.messageSource.getMessage(key, (Object[])params, locale);
        }
        catch (Exception e) {
            log.error("Hydrogen i18n get value error with key [{}], msg: {}", new Object[]{key, e.getMessage(), e});
            return key;
        }
    }

    public void setFixedLocale(String localeIdentifier) {
        this.setFixedLocale(StringUtils.parseLocale((String)localeIdentifier));
    }

    public void setFixedLocale(Locale locale) {
        LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)WebContext.getRequest());
        if (localeResolver == null) {
            throw new IllegalStateException("No LocaleResolver found: not in a DispatcherServlet request?");
        }
        localeResolver.setLocale(WebContext.getRequest(), WebContext.getRequestAttributes().getResponse(), locale);
    }

    public I18nMessages(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

