/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.interceptor;

import com.github.yizzuide.milkomeda.universe.context.WebContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.MappedInterceptor;

public class HydrogenMappedInterceptor
implements HandlerInterceptor,
Ordered {
    private MappedInterceptor mappedInterceptor;
    private int order = 0;

    public HydrogenMappedInterceptor(MappedInterceptor mappedInterceptor) {
        this.mappedInterceptor = mappedInterceptor;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String lookupPath = WebContext.getUrlPathHelper().getLookupPathForRequest(request, HandlerMapping.LOOKUP_PATH);
        if (this.mappedInterceptor.matches(lookupPath, WebContext.getMvcPathMatcher())) {
            return this.mappedInterceptor.preHandle(request, response, handler);
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String lookupPath = WebContext.getUrlPathHelper().getLookupPathForRequest(request, HandlerMapping.LOOKUP_PATH);
        if (this.mappedInterceptor.matches(lookupPath, WebContext.getMvcPathMatcher())) {
            this.mappedInterceptor.postHandle(request, response, handler, modelAndView);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.mappedInterceptor.afterCompletion(request, response, handler, ex);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HandlerInterceptor)) {
            return false;
        }
        if (obj instanceof HydrogenMappedInterceptor) {
            return this.getMappedInterceptor().getInterceptor().getClass() == ((HydrogenMappedInterceptor)obj).getMappedInterceptor().getInterceptor().getClass();
        }
        return this.getMappedInterceptor().getInterceptor().getClass() == obj.getClass();
    }

    public MappedInterceptor getMappedInterceptor() {
        return this.mappedInterceptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void setMappedInterceptor(MappedInterceptor mappedInterceptor) {
        this.mappedInterceptor = mappedInterceptor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String toString() {
        return "HydrogenMappedInterceptor(mappedInterceptor=" + this.getMappedInterceptor() + ", order=" + this.getOrder() + ")";
    }
}

