/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.interceptor;

import com.github.yizzuide.milkomeda.hydrogen.interceptor.InterceptorLoader;
import com.github.yizzuide.milkomeda.hydrogen.interceptor.InterceptorProperties;
import com.github.yizzuide.milkomeda.hydrogen.interceptor.WebMvcInterceptorLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@EnableConfigurationProperties(value={InterceptorProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@ConditionalOnProperty(prefix="milkomeda.hydrogen.interceptor", name={"enable"}, havingValue="true")
public class InterceptorConfig {
    private static final Logger log = LoggerFactory.getLogger(InterceptorConfig.class);

    @Bean
    @ConditionalOnClass(name={"org.springframework.web.servlet.HandlerInterceptor"})
    public InterceptorLoader interceptorHandler(InterceptorProperties interceptorProperties, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        return new WebMvcInterceptorLoader(interceptorProperties, requestMappingHandlerMapping);
    }
}

