/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.interceptor;

import com.github.yizzuide.milkomeda.hydrogen.interceptor.AbstractInterceptorLoader;
import com.github.yizzuide.milkomeda.hydrogen.interceptor.InterceptorProperties;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.universe.polyfill.SpringMvcPolyfill;
import com.github.yizzuide.milkomeda.util.ReflectUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class WebMvcInterceptorLoader
extends AbstractInterceptorLoader<InterceptorProperties.Interceptors> {
    private static final Logger log = LoggerFactory.getLogger(WebMvcInterceptorLoader.class);
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    private InterceptorProperties props;

    public WebMvcInterceptorLoader(InterceptorProperties interceptorProperties, RequestMappingHandlerMapping requestMappingHandlerMapping) {
        this.props = interceptorProperties;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
    }

    @Override
    public void load(@NonNull Class<?> clazz, List<String> include, List<String> exclude, int order, Map<String, Object> props) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        InterceptorProperties.Interceptors hInterceptor = new InterceptorProperties.Interceptors();
        hInterceptor.setClazz(clazz);
        if (include != null) {
            hInterceptor.setIncludeURLs(include);
        }
        hInterceptor.setExcludeURLs(exclude);
        hInterceptor.setOrder(order);
        if (props != null) {
            hInterceptor.setProps(props);
        }
        this.transform(Collections.singletonList(hInterceptor), (hi, handlerInterceptor) -> SpringMvcPolyfill.addDynamicInterceptor(handlerInterceptor, hInterceptor.getOrder(), hi.getIncludeURLs(), hi.getExcludeURLs(), (AbstractHandlerMapping)this.requestMappingHandlerMapping));
    }

    @Override
    public void unLoad(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        InterceptorProperties.Interceptors hInterceptor = new InterceptorProperties.Interceptors();
        hInterceptor.setClazz(clazz);
        this.transform(Collections.singletonList(hInterceptor), (hi, handlerInterceptor) -> SpringMvcPolyfill.removeDynamicInterceptor(handlerInterceptor, (AbstractHandlerMapping)this.requestMappingHandlerMapping));
    }

    @Override
    public List<Map<String, String>> inspect() {
        return SpringMvcPolyfill.getInterceptorsInfo((AbstractHandlerMapping)this.requestMappingHandlerMapping);
    }

    @Override
    public void refresh() {
        List<InterceptorProperties.Interceptors> afterInterceptors = this.props.getInterceptors();
        this.merge(afterInterceptors, i -> this.unLoad(i.getClazz()), i -> this.load(i.getClazz(), i.getIncludeURLs(), i.getExcludeURLs(), i.getOrder(), i.getProps()));
    }

    private void transform(List<InterceptorProperties.Interceptors> hydrogenInterceptors, @NonNull BiConsumer<InterceptorProperties.Interceptors, HandlerInterceptor> performAction) {
        if (performAction == null) {
            throw new NullPointerException("performAction is marked non-null but is null");
        }
        if (CollectionUtils.isEmpty(hydrogenInterceptors)) {
            return;
        }
        hydrogenInterceptors.forEach(hi -> {
            HandlerInterceptor handlerInterceptorBean = null;
            try {
                handlerInterceptorBean = (HandlerInterceptor)this.getApplicationContext().getBean(hi.getClazz());
            }
            catch (BeansException beansException) {
                // empty catch block
            }
            if (handlerInterceptorBean == null) {
                handlerInterceptorBean = (HandlerInterceptor)WebContext.registerBean((ConfigurableApplicationContext)this.getApplicationContext(), hi.getClazz().getSimpleName(), hi.getClazz(), new Object[0]);
                this.getApplicationContext().getAutowireCapableBeanFactory().autowireBean((Object)handlerInterceptorBean);
            }
            try {
                ReflectUtil.setField(handlerInterceptorBean, hi.getProps());
                performAction.accept((InterceptorProperties.Interceptors)hi, handlerInterceptorBean);
            }
            catch (Exception e) {
                log.error("Hydrogen interceptor add error with msg: {}", (Object)e.getMessage(), (Object)e);
            }
        });
    }
}

