/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.transaction;

import com.github.yizzuide.milkomeda.hydrogen.transaction.TransactionProperties;
import java.util.stream.Collectors;
import org.aopalliance.aop.Advice;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.transaction.TransactionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.NameMatchTransactionAttributeSource;
import org.springframework.transaction.interceptor.RollbackRuleAttribute;
import org.springframework.transaction.interceptor.RuleBasedTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;
import org.springframework.util.CollectionUtils;

@Aspect
@Configuration
@EnableConfigurationProperties(value={TransactionProperties.class})
@AutoConfigureAfter(value={TransactionAutoConfiguration.class})
@ConditionalOnProperty(prefix="milkomeda.hydrogen.transaction", name={"enable"}, havingValue="true")
public class TransactionConfig {
    @Autowired
    private TransactionProperties props;

    @Bean
    public TransactionInterceptor txAdvice(PlatformTransactionManager transactionManager) {
        RuleBasedTransactionAttribute txAttr_REQUIRED = new RuleBasedTransactionAttribute();
        txAttr_REQUIRED.setPropagationBehavior(0);
        txAttr_REQUIRED.setRollbackRules(this.props.getRollbackWhenException().stream().map(RollbackRuleAttribute::new).collect(Collectors.toList()));
        txAttr_REQUIRED.setTimeout((int)this.props.getRollbackWhenTimeout().getSeconds());
        RuleBasedTransactionAttribute txAttr_READONLY = new RuleBasedTransactionAttribute();
        txAttr_READONLY.setPropagationBehavior(4);
        txAttr_READONLY.setReadOnly(true);
        NameMatchTransactionAttributeSource source = new NameMatchTransactionAttributeSource();
        if (!CollectionUtils.isEmpty(this.props.getReadOnlyPrefix())) {
            for (String prefix : this.props.getReadOnlyPrefix()) {
                source.addTransactionalMethod(prefix, (TransactionAttribute)txAttr_READONLY);
            }
        }
        if (!CollectionUtils.isEmpty(this.props.getReadOnlyAppendPrefix())) {
            for (String prefix : this.props.getReadOnlyAppendPrefix()) {
                source.addTransactionalMethod(prefix, (TransactionAttribute)txAttr_READONLY);
            }
        }
        source.addTransactionalMethod("*", (TransactionAttribute)txAttr_REQUIRED);
        return new TransactionInterceptor(transactionManager, (TransactionAttributeSource)source);
    }

    @Bean
    public Advisor txAdviceAdvisor(TransactionInterceptor txAdvice) {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(this.props.getPointcutExpression());
        return new DefaultPointcutAdvisor((Pointcut)pointcut, (Advice)txAdvice);
    }
}

