/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.transaction;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="milkomeda.hydrogen.transaction")
public class TransactionProperties {
    private boolean enable = false;
    private String pointcutExpression = "execution(* com..service.*.*(..))";
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration rollbackWhenTimeout = Duration.ofSeconds(-1L);
    private List<Class<? extends Exception>> rollbackWhenException = Collections.singletonList(Exception.class);
    private List<String> readOnlyPrefix = Arrays.asList("get*", "query*", "find*", "select*", "list*", "count*", "is*");
    private List<String> readOnlyAppendPrefix;

    public boolean isEnable() {
        return this.enable;
    }

    public String getPointcutExpression() {
        return this.pointcutExpression;
    }

    public Duration getRollbackWhenTimeout() {
        return this.rollbackWhenTimeout;
    }

    public List<Class<? extends Exception>> getRollbackWhenException() {
        return this.rollbackWhenException;
    }

    public List<String> getReadOnlyPrefix() {
        return this.readOnlyPrefix;
    }

    public List<String> getReadOnlyAppendPrefix() {
        return this.readOnlyAppendPrefix;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public void setPointcutExpression(String pointcutExpression) {
        this.pointcutExpression = pointcutExpression;
    }

    public void setRollbackWhenTimeout(Duration rollbackWhenTimeout) {
        this.rollbackWhenTimeout = rollbackWhenTimeout;
    }

    public void setRollbackWhenException(List<Class<? extends Exception>> rollbackWhenException) {
        this.rollbackWhenException = rollbackWhenException;
    }

    public void setReadOnlyPrefix(List<String> readOnlyPrefix) {
        this.readOnlyPrefix = readOnlyPrefix;
    }

    public void setReadOnlyAppendPrefix(List<String> readOnlyAppendPrefix) {
        this.readOnlyAppendPrefix = readOnlyAppendPrefix;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionProperties)) {
            return false;
        }
        TransactionProperties other = (TransactionProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnable() != other.isEnable()) {
            return false;
        }
        String this$pointcutExpression = this.getPointcutExpression();
        String other$pointcutExpression = other.getPointcutExpression();
        if (this$pointcutExpression == null ? other$pointcutExpression != null : !this$pointcutExpression.equals(other$pointcutExpression)) {
            return false;
        }
        Duration this$rollbackWhenTimeout = this.getRollbackWhenTimeout();
        Duration other$rollbackWhenTimeout = other.getRollbackWhenTimeout();
        if (this$rollbackWhenTimeout == null ? other$rollbackWhenTimeout != null : !((Object)this$rollbackWhenTimeout).equals(other$rollbackWhenTimeout)) {
            return false;
        }
        List<Class<? extends Exception>> this$rollbackWhenException = this.getRollbackWhenException();
        List<Class<? extends Exception>> other$rollbackWhenException = other.getRollbackWhenException();
        if (this$rollbackWhenException == null ? other$rollbackWhenException != null : !((Object)this$rollbackWhenException).equals(other$rollbackWhenException)) {
            return false;
        }
        List<String> this$readOnlyPrefix = this.getReadOnlyPrefix();
        List<String> other$readOnlyPrefix = other.getReadOnlyPrefix();
        if (this$readOnlyPrefix == null ? other$readOnlyPrefix != null : !((Object)this$readOnlyPrefix).equals(other$readOnlyPrefix)) {
            return false;
        }
        List<String> this$readOnlyAppendPrefix = this.getReadOnlyAppendPrefix();
        List<String> other$readOnlyAppendPrefix = other.getReadOnlyAppendPrefix();
        return !(this$readOnlyAppendPrefix == null ? other$readOnlyAppendPrefix != null : !((Object)this$readOnlyAppendPrefix).equals(other$readOnlyAppendPrefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnable() ? 79 : 97);
        String $pointcutExpression = this.getPointcutExpression();
        result = result * 59 + ($pointcutExpression == null ? 43 : $pointcutExpression.hashCode());
        Duration $rollbackWhenTimeout = this.getRollbackWhenTimeout();
        result = result * 59 + ($rollbackWhenTimeout == null ? 43 : ((Object)$rollbackWhenTimeout).hashCode());
        List<Class<? extends Exception>> $rollbackWhenException = this.getRollbackWhenException();
        result = result * 59 + ($rollbackWhenException == null ? 43 : ((Object)$rollbackWhenException).hashCode());
        List<String> $readOnlyPrefix = this.getReadOnlyPrefix();
        result = result * 59 + ($readOnlyPrefix == null ? 43 : ((Object)$readOnlyPrefix).hashCode());
        List<String> $readOnlyAppendPrefix = this.getReadOnlyAppendPrefix();
        result = result * 59 + ($readOnlyAppendPrefix == null ? 43 : ((Object)$readOnlyAppendPrefix).hashCode());
        return result;
    }

    public String toString() {
        return "TransactionProperties(enable=" + this.isEnable() + ", pointcutExpression=" + this.getPointcutExpression() + ", rollbackWhenTimeout=" + this.getRollbackWhenTimeout() + ", rollbackWhenException=" + this.getRollbackWhenException() + ", readOnlyPrefix=" + this.getReadOnlyPrefix() + ", readOnlyAppendPrefix=" + this.getReadOnlyAppendPrefix() + ")";
    }
}

