/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.uniform;

import com.github.yizzuide.milkomeda.hydrogen.uniform.UniformProperties;
import com.github.yizzuide.milkomeda.universe.context.WebContext;
import com.github.yizzuide.milkomeda.universe.parser.yml.YmlResponseOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

public class UniformHandler
extends ResponseEntityExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(UniformHandler.class);
    @Autowired
    private UniformProperties props;
    private List<Map<String, Object>> customConfList;

    @PostConstruct
    public void init() {
        Object customs = this.props.getResponse().get("customs");
        if (customs == null) {
            return;
        }
        this.customConfList = new ArrayList<Map<String, Object>>();
        Map customsMap = (Map)customs;
        for (String k : customsMap.keySet()) {
            Class<?> expClazz;
            Map eleMap = (Map)customsMap.get(k);
            Object clazz = eleMap.get("clazz");
            if (!(clazz instanceof String)) continue;
            try {
                expClazz = Class.forName(clazz.toString());
            }
            catch (Exception ex) {
                log.error("Hydrogen load class error with msg: {}", (Object)ex.getMessage(), (Object)ex);
                continue;
            }
            eleMap.put("clazz", expClazz);
            this.customConfList.add(eleMap);
        }
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseEntity<Object> responseEntity = this.handleExceptionResponse(ex, status.value(), ex.getMessage());
        if (responseEntity == null) {
            return super.handleExceptionInternal(ex, body, headers, status, request);
        }
        return responseEntity;
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<Object> constraintViolationException(ConstraintViolationException e) {
        ConstraintViolation constraintViolation = (ConstraintViolation)e.getConstraintViolations().iterator().next();
        String value = String.valueOf(constraintViolation.getInvalidValue());
        String message = WebContext.getRequest().getRequestURI() + " [" + constraintViolation.getPropertyPath() + "=" + value + "] " + constraintViolation.getMessage();
        log.warn("Hydrogen uniform valid response exception with msg: {} ", (Object)message);
        ResponseEntity responseEntity = this.handleExceptionResponse((Exception)e, HttpStatus.BAD_REQUEST.value(), message);
        return responseEntity == null ? ResponseEntity.status((int)HttpStatus.BAD_REQUEST.value()).body(null) : responseEntity;
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseEntity responseEntity = this.handleValidBeanExceptionResponse((Exception)ex, ex.getBindingResult());
        return responseEntity == null ? super.handleMethodArgumentNotValid(ex, headers, status, request) : responseEntity;
    }

    protected ResponseEntity<Object> handleBindException(BindException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        ResponseEntity responseEntity = this.handleValidBeanExceptionResponse((Exception)ex, ex.getBindingResult());
        return responseEntity == null ? super.handleBindException(ex, headers, status, request) : responseEntity;
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleException(Exception e) throws IOException {
        Map<String, Object> response = this.props.getResponse();
        Object status = response.get("status");
        status = status == null ? Integer.valueOf(500) : status;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.customConfList != null) {
            for (Map<String, Object> map : this.customConfList) {
                Class exceptionClass = (Class)map.get("clazz");
                if (!exceptionClass.isInstance(e)) continue;
                YmlResponseOutput.output(map, result, null, e, true);
                return ResponseEntity.status((int)Integer.parseInt(status.toString())).body(result);
            }
        }
        log.error("Hydrogen uniform response exception with msg: {}", (Object)e.getMessage(), (Object)e);
        YmlResponseOutput.output(response, result, null, e, false);
        return ResponseEntity.status((int)Integer.parseInt(status.toString())).body(result);
    }

    private ResponseEntity<Object> handleValidBeanExceptionResponse(Exception ex, BindingResult bindingResult) {
        ObjectError objectError = (ObjectError)bindingResult.getAllErrors().get(0);
        String message = objectError.getDefaultMessage();
        if (objectError.getArguments() != null && objectError.getArguments().length > 0) {
            FieldError fieldError = (FieldError)objectError;
            message = WebContext.getRequest().getRequestURI() + " [" + fieldError.getField() + "=" + fieldError.getRejectedValue() + "] " + message;
        }
        log.warn("Hydrogen uniform valid response exception with msg: {} ", (Object)message);
        return this.handleExceptionResponse(ex, HttpStatus.BAD_REQUEST.value(), message);
    }

    private ResponseEntity<Object> handleExceptionResponse(Exception ex, Object presetStatusCode, String presetMessage) {
        Map<String, Object> response = this.props.getResponse();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object exp4xx = response.get(presetStatusCode.toString());
        if (!(exp4xx instanceof Map)) {
            log.warn("Hydrogen uniform can't find {} code response.", presetStatusCode);
            return null;
        }
        Map exp4xxResponse = (Map)exp4xx;
        Object statusCode4xx = exp4xxResponse.get("status");
        if (statusCode4xx == null || presetStatusCode.equals(statusCode4xx)) {
            return ResponseEntity.status((int)Integer.parseInt(presetStatusCode.toString())).body(null);
        }
        HashMap<String, Object> defValMap = new HashMap<String, Object>();
        defValMap.put("code", presetStatusCode);
        defValMap.put("message", presetMessage);
        YmlResponseOutput.output(exp4xxResponse, result, defValMap, null, false);
        return ResponseEntity.status((int)Integer.parseInt(statusCode4xx.toString())).body(result);
    }
}

