/*
 * Decompiled with CFR 0.152.
 */
package com.github.yizzuide.milkomeda.hydrogen.validator;

import com.github.yizzuide.milkomeda.hydrogen.core.HydrogenHolder;
import com.github.yizzuide.milkomeda.hydrogen.validator.ValidatorHolder;
import com.github.yizzuide.milkomeda.hydrogen.validator.ValidatorProperties;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.validation.ValidationAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.beanvalidation.MethodValidationPostProcessor;

@Configuration
@EnableConfigurationProperties(value={ValidatorProperties.class})
@AutoConfigureAfter(value={ValidationAutoConfiguration.class})
@ConditionalOnProperty(prefix="milkomeda.hydrogen.validator", name={"enable"}, havingValue="true")
public class ValidatorConfig {
    @Autowired
    public void config(ValidatorProperties validatorProperties) {
        ValidatorHolder.setProps(validatorProperties);
    }

    @Bean
    public MethodValidationPostProcessor methodValidationPostProcessor() {
        MethodValidationPostProcessor postProcessor = new MethodValidationPostProcessor();
        postProcessor.setValidator(this.validator());
        return postProcessor;
    }

    @Bean
    public Validator validator() {
        ValidatorFactory validatorFactory = ((HibernateValidatorConfiguration)Validation.byProvider(HibernateValidator.class).configure()).failFast(true).buildValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        HydrogenHolder.setValidator(validator);
        return validator;
    }
}

